package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.ChimeArn
import scala.jdk.CollectionConverters._
final case class CreateChannelResponse(
    channelArn: Optional[ChimeArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelResponse = {
    import CreateChannelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelResponse
      .builder()
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.CreateChannelResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.CreateChannelResponse.wrap(buildAwsValue())
}
object CreateChannelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.CreateChannelResponse =
      zio.aws.chimesdkmessaging.model
        .CreateChannelResponse(channelArn.map(value => value))
    def channelArn: Optional[ChimeArn]
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelResponse
  ) extends zio.aws.chimesdkmessaging.model.CreateChannelResponse.ReadOnly {
    override val channelArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelResponse
  ): zio.aws.chimesdkmessaging.model.CreateChannelResponse.ReadOnly =
    new Wrapper(impl)
}
