package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListChannelsModeratedByAppInstanceUserResponse(
    channels: Optional[Iterable[
      zio.aws.chimesdkmessaging.model.ChannelModeratedByAppInstanceUserSummary
    ]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserResponse = {
    import ListChannelsModeratedByAppInstanceUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserResponse
      .builder()
      .optionallyWith(
        channels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.channels)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserResponse
      .wrap(buildAwsValue())
}
object ListChannelsModeratedByAppInstanceUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserResponse =
      zio.aws.chimesdkmessaging.model
        .ListChannelsModeratedByAppInstanceUserResponse(
          channels.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def channels: Optional[List[
      zio.aws.chimesdkmessaging.model.ChannelModeratedByAppInstanceUserSummary.ReadOnly
    ]]
    def nextToken: Optional[NextToken]
    def getChannels: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmessaging.model.ChannelModeratedByAppInstanceUserSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("channels", channels)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserResponse
  ) extends zio.aws.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserResponse.ReadOnly {
    override val channels: Optional[List[
      zio.aws.chimesdkmessaging.model.ChannelModeratedByAppInstanceUserSummary.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.channels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkmessaging.model.ChannelModeratedByAppInstanceUserSummary
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserResponse
  ): zio.aws.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserResponse.ReadOnly =
    new Wrapper(impl)
}
