package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.FilterRule
import scala.jdk.CollectionConverters._
final case class PushNotificationPreferences(
    allowNotifications: zio.aws.chimesdkmessaging.model.AllowNotifications,
    filterRule: Optional[FilterRule] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.PushNotificationPreferences = {
    import PushNotificationPreferences.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.PushNotificationPreferences
      .builder()
      .allowNotifications(allowNotifications.unwrap)
      .optionallyWith(
        filterRule.map(value => FilterRule.unwrap(value): java.lang.String)
      )(_.filterRule)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.PushNotificationPreferences.ReadOnly =
    zio.aws.chimesdkmessaging.model.PushNotificationPreferences
      .wrap(buildAwsValue())
}
object PushNotificationPreferences {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.PushNotificationPreferences
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.PushNotificationPreferences =
      zio.aws.chimesdkmessaging.model.PushNotificationPreferences(
        allowNotifications,
        filterRule.map(value => value)
      )
    def allowNotifications: zio.aws.chimesdkmessaging.model.AllowNotifications
    def filterRule: Optional[FilterRule]
    def getAllowNotifications: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmessaging.model.AllowNotifications
    ] = ZIO.succeed(allowNotifications)
    def getFilterRule: ZIO[Any, AwsError, FilterRule] =
      AwsError.unwrapOptionField("filterRule", filterRule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.PushNotificationPreferences
  ) extends zio.aws.chimesdkmessaging.model.PushNotificationPreferences.ReadOnly {
    override val allowNotifications
        : zio.aws.chimesdkmessaging.model.AllowNotifications =
      zio.aws.chimesdkmessaging.model.AllowNotifications
        .wrap(impl.allowNotifications())
    override val filterRule: Optional[FilterRule] = zio.aws.core.internal
      .optionalFromNullable(impl.filterRule())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.FilterRule(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.PushNotificationPreferences
  ): zio.aws.chimesdkmessaging.model.PushNotificationPreferences.ReadOnly =
    new Wrapper(impl)
}
