package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.{NextToken, ChimeArn}
import scala.jdk.CollectionConverters._
final case class ListChannelModeratorsResponse(
    channelArn: Optional[ChimeArn] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    channelModerators: Optional[
      Iterable[zio.aws.chimesdkmessaging.model.ChannelModeratorSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelModeratorsResponse = {
    import ListChannelModeratorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelModeratorsResponse
      .builder()
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        channelModerators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.channelModerators)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ListChannelModeratorsResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.ListChannelModeratorsResponse
      .wrap(buildAwsValue())
}
object ListChannelModeratorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelModeratorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.ListChannelModeratorsResponse =
      zio.aws.chimesdkmessaging.model.ListChannelModeratorsResponse(
        channelArn.map(value => value),
        nextToken.map(value => value),
        channelModerators.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def channelArn: Optional[ChimeArn]
    def nextToken: Optional[NextToken]
    def channelModerators: Optional[
      List[zio.aws.chimesdkmessaging.model.ChannelModeratorSummary.ReadOnly]
    ]
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getChannelModerators: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmessaging.model.ChannelModeratorSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("channelModerators", channelModerators)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelModeratorsResponse
  ) extends zio.aws.chimesdkmessaging.model.ListChannelModeratorsResponse.ReadOnly {
    override val channelArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.NextToken(value))
    override val channelModerators: Optional[
      List[zio.aws.chimesdkmessaging.model.ChannelModeratorSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.channelModerators())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkmessaging.model.ChannelModeratorSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelModeratorsResponse
  ): zio.aws.chimesdkmessaging.model.ListChannelModeratorsResponse.ReadOnly =
    new Wrapper(impl)
}
