package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ChannelBanSummary(
    member: Optional[zio.aws.chimesdkmessaging.model.Identity] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ChannelBanSummary = {
    import ChannelBanSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelBanSummary
      .builder()
      .optionallyWith(member.map(value => value.buildAwsValue()))(_.member)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmessaging.model.ChannelBanSummary.ReadOnly =
    zio.aws.chimesdkmessaging.model.ChannelBanSummary.wrap(buildAwsValue())
}
object ChannelBanSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelBanSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.ChannelBanSummary =
      zio.aws.chimesdkmessaging.model
        .ChannelBanSummary(member.map(value => value.asEditable))
    def member: Optional[zio.aws.chimesdkmessaging.model.Identity.ReadOnly]
    def getMember: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.Identity.ReadOnly
    ] = AwsError.unwrapOptionField("member", member)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelBanSummary
  ) extends zio.aws.chimesdkmessaging.model.ChannelBanSummary.ReadOnly {
    override val member
        : Optional[zio.aws.chimesdkmessaging.model.Identity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.member())
        .map(value => zio.aws.chimesdkmessaging.model.Identity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelBanSummary
  ): zio.aws.chimesdkmessaging.model.ChannelBanSummary.ReadOnly = new Wrapper(
    impl
  )
}
