package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmessaging.model.primitives.SearchFieldValue
import scala.jdk.CollectionConverters._
final case class SearchField(
    key: zio.aws.chimesdkmessaging.model.SearchFieldKey,
    values: Iterable[SearchFieldValue],
    operator: zio.aws.chimesdkmessaging.model.SearchFieldOperator
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.SearchField = {
    import SearchField.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.SearchField
      .builder()
      .key(key.unwrap)
      .values(values.map { item =>
        SearchFieldValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .operator(operator.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmessaging.model.SearchField.ReadOnly =
    zio.aws.chimesdkmessaging.model.SearchField.wrap(buildAwsValue())
}
object SearchField {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.SearchField
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.SearchField =
      zio.aws.chimesdkmessaging.model.SearchField(key, values, operator)
    def key: zio.aws.chimesdkmessaging.model.SearchFieldKey
    def values: List[SearchFieldValue]
    def operator: zio.aws.chimesdkmessaging.model.SearchFieldOperator
    def getKey
        : ZIO[Any, Nothing, zio.aws.chimesdkmessaging.model.SearchFieldKey] =
      ZIO.succeed(key)
    def getValues: ZIO[Any, Nothing, List[SearchFieldValue]] =
      ZIO.succeed(values)
    def getOperator: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmessaging.model.SearchFieldOperator
    ] = ZIO.succeed(operator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.SearchField
  ) extends zio.aws.chimesdkmessaging.model.SearchField.ReadOnly {
    override val key: zio.aws.chimesdkmessaging.model.SearchFieldKey =
      zio.aws.chimesdkmessaging.model.SearchFieldKey.wrap(impl.key())
    override val values: List[SearchFieldValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.chimesdkmessaging.model.primitives.SearchFieldValue(item)
      }
      .toList
    override val operator: zio.aws.chimesdkmessaging.model.SearchFieldOperator =
      zio.aws.chimesdkmessaging.model.SearchFieldOperator.wrap(impl.operator())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.SearchField
  ): zio.aws.chimesdkmessaging.model.SearchField.ReadOnly = new Wrapper(impl)
}
