package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.{
  SubChannelId,
  MessageId,
  ChimeArn
}
import scala.jdk.CollectionConverters._
final case class RedactChannelMessageResponse(
    channelArn: Optional[ChimeArn] = Optional.Absent,
    messageId: Optional[MessageId] = Optional.Absent,
    subChannelId: Optional[SubChannelId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.RedactChannelMessageResponse = {
    import RedactChannelMessageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.RedactChannelMessageResponse
      .builder()
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(
        messageId.map(value => MessageId.unwrap(value): java.lang.String)
      )(_.messageId)
      .optionallyWith(
        subChannelId.map(value => SubChannelId.unwrap(value): java.lang.String)
      )(_.subChannelId)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.RedactChannelMessageResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.RedactChannelMessageResponse
      .wrap(buildAwsValue())
}
object RedactChannelMessageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.RedactChannelMessageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.RedactChannelMessageResponse =
      zio.aws.chimesdkmessaging.model.RedactChannelMessageResponse(
        channelArn.map(value => value),
        messageId.map(value => value),
        subChannelId.map(value => value)
      )
    def channelArn: Optional[ChimeArn]
    def messageId: Optional[MessageId]
    def subChannelId: Optional[SubChannelId]
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getMessageId: ZIO[Any, AwsError, MessageId] =
      AwsError.unwrapOptionField("messageId", messageId)
    def getSubChannelId: ZIO[Any, AwsError, SubChannelId] =
      AwsError.unwrapOptionField("subChannelId", subChannelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.RedactChannelMessageResponse
  ) extends zio.aws.chimesdkmessaging.model.RedactChannelMessageResponse.ReadOnly {
    override val channelArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val messageId: Optional[MessageId] = zio.aws.core.internal
      .optionalFromNullable(impl.messageId())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.MessageId(value))
    override val subChannelId: Optional[SubChannelId] = zio.aws.core.internal
      .optionalFromNullable(impl.subChannelId())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.SubChannelId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.RedactChannelMessageResponse
  ): zio.aws.chimesdkmessaging.model.RedactChannelMessageResponse.ReadOnly =
    new Wrapper(impl)
}
