package zio.aws.chimesdkmessaging.model
import zio.aws.chimesdkmessaging.model.primitives.{
  NextToken,
  MaxResults,
  ChimeArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListChannelsAssociatedWithChannelFlowRequest(
    channelFlowArn: ChimeArn,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowRequest = {
    import ListChannelsAssociatedWithChannelFlowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowRequest
      .builder()
      .channelFlowArn(ChimeArn.unwrap(channelFlowArn): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowRequest
      .wrap(buildAwsValue())
}
object ListChannelsAssociatedWithChannelFlowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowRequest =
      zio.aws.chimesdkmessaging.model
        .ListChannelsAssociatedWithChannelFlowRequest(
          channelFlowArn,
          maxResults.map(value => value),
          nextToken.map(value => value)
        )
    def channelFlowArn: ChimeArn
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getChannelFlowArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(channelFlowArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowRequest
  ) extends zio.aws.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowRequest.ReadOnly {
    override val channelFlowArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.channelFlowArn())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.MaxResults(value)
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowRequest
  ): zio.aws.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowRequest.ReadOnly =
    new Wrapper(impl)
}
