package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.ChimeArn
import scala.jdk.CollectionConverters._
final case class PutChannelMembershipPreferencesResponse(
    channelArn: Optional[ChimeArn] = Optional.Absent,
    member: Optional[zio.aws.chimesdkmessaging.model.Identity] =
      Optional.Absent,
    preferences: Optional[
      zio.aws.chimesdkmessaging.model.ChannelMembershipPreferences
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.PutChannelMembershipPreferencesResponse = {
    import PutChannelMembershipPreferencesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.PutChannelMembershipPreferencesResponse
      .builder()
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(member.map(value => value.buildAwsValue()))(_.member)
      .optionallyWith(preferences.map(value => value.buildAwsValue()))(
        _.preferences
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.PutChannelMembershipPreferencesResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.PutChannelMembershipPreferencesResponse
      .wrap(buildAwsValue())
}
object PutChannelMembershipPreferencesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.PutChannelMembershipPreferencesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.PutChannelMembershipPreferencesResponse =
      zio.aws.chimesdkmessaging.model.PutChannelMembershipPreferencesResponse(
        channelArn.map(value => value),
        member.map(value => value.asEditable),
        preferences.map(value => value.asEditable)
      )
    def channelArn: Optional[ChimeArn]
    def member: Optional[zio.aws.chimesdkmessaging.model.Identity.ReadOnly]
    def preferences: Optional[
      zio.aws.chimesdkmessaging.model.ChannelMembershipPreferences.ReadOnly
    ]
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getMember: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.Identity.ReadOnly
    ] = AwsError.unwrapOptionField("member", member)
    def getPreferences: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelMembershipPreferences.ReadOnly
    ] = AwsError.unwrapOptionField("preferences", preferences)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.PutChannelMembershipPreferencesResponse
  ) extends zio.aws.chimesdkmessaging.model.PutChannelMembershipPreferencesResponse.ReadOnly {
    override val channelArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val member
        : Optional[zio.aws.chimesdkmessaging.model.Identity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.member())
        .map(value => zio.aws.chimesdkmessaging.model.Identity.wrap(value))
    override val preferences: Optional[
      zio.aws.chimesdkmessaging.model.ChannelMembershipPreferences.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.preferences())
      .map(value =>
        zio.aws.chimesdkmessaging.model.ChannelMembershipPreferences.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.PutChannelMembershipPreferencesResponse
  ): zio.aws.chimesdkmessaging.model.PutChannelMembershipPreferencesResponse.ReadOnly =
    new Wrapper(impl)
}
