package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ChannelModeratedByAppInstanceUserSummary(
    channelSummary: Optional[zio.aws.chimesdkmessaging.model.ChannelSummary] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ChannelModeratedByAppInstanceUserSummary = {
    import ChannelModeratedByAppInstanceUserSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelModeratedByAppInstanceUserSummary
      .builder()
      .optionallyWith(channelSummary.map(value => value.buildAwsValue()))(
        _.channelSummary
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ChannelModeratedByAppInstanceUserSummary.ReadOnly =
    zio.aws.chimesdkmessaging.model.ChannelModeratedByAppInstanceUserSummary
      .wrap(buildAwsValue())
}
object ChannelModeratedByAppInstanceUserSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelModeratedByAppInstanceUserSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.ChannelModeratedByAppInstanceUserSummary =
      zio.aws.chimesdkmessaging.model.ChannelModeratedByAppInstanceUserSummary(
        channelSummary.map(value => value.asEditable)
      )
    def channelSummary
        : Optional[zio.aws.chimesdkmessaging.model.ChannelSummary.ReadOnly]
    def getChannelSummary: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelSummary.ReadOnly
    ] = AwsError.unwrapOptionField("channelSummary", channelSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelModeratedByAppInstanceUserSummary
  ) extends zio.aws.chimesdkmessaging.model.ChannelModeratedByAppInstanceUserSummary.ReadOnly {
    override val channelSummary
        : Optional[zio.aws.chimesdkmessaging.model.ChannelSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channelSummary())
        .map(value =>
          zio.aws.chimesdkmessaging.model.ChannelSummary.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelModeratedByAppInstanceUserSummary
  ): zio.aws.chimesdkmessaging.model.ChannelModeratedByAppInstanceUserSummary.ReadOnly =
    new Wrapper(impl)
}
