package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmessaging.model.primitives.{
  NonEmptyResourceName,
  ChimeArn
}
import scala.jdk.CollectionConverters._
final case class UpdateChannelFlowRequest(
    channelFlowArn: ChimeArn,
    processors: Iterable[zio.aws.chimesdkmessaging.model.Processor],
    name: NonEmptyResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelFlowRequest = {
    import UpdateChannelFlowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelFlowRequest
      .builder()
      .channelFlowArn(ChimeArn.unwrap(channelFlowArn): java.lang.String)
      .processors(processors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .name(NonEmptyResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.UpdateChannelFlowRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.UpdateChannelFlowRequest
      .wrap(buildAwsValue())
}
object UpdateChannelFlowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelFlowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.UpdateChannelFlowRequest =
      zio.aws.chimesdkmessaging.model.UpdateChannelFlowRequest(
        channelFlowArn,
        processors.map { item =>
          item.asEditable
        },
        name
      )
    def channelFlowArn: ChimeArn
    def processors: List[zio.aws.chimesdkmessaging.model.Processor.ReadOnly]
    def name: NonEmptyResourceName
    def getChannelFlowArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(channelFlowArn)
    def getProcessors: ZIO[Any, Nothing, List[
      zio.aws.chimesdkmessaging.model.Processor.ReadOnly
    ]] = ZIO.succeed(processors)
    def getName: ZIO[Any, Nothing, NonEmptyResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelFlowRequest
  ) extends zio.aws.chimesdkmessaging.model.UpdateChannelFlowRequest.ReadOnly {
    override val channelFlowArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.channelFlowArn())
    override val processors
        : List[zio.aws.chimesdkmessaging.model.Processor.ReadOnly] = impl
      .processors()
      .asScala
      .map { item =>
        zio.aws.chimesdkmessaging.model.Processor.wrap(item)
      }
      .toList
    override val name: NonEmptyResourceName =
      zio.aws.chimesdkmessaging.model.primitives
        .NonEmptyResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelFlowRequest
  ): zio.aws.chimesdkmessaging.model.UpdateChannelFlowRequest.ReadOnly =
    new Wrapper(impl)
}
