package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmessaging.model.primitives.LambdaFunctionArn
import scala.jdk.CollectionConverters._
final case class LambdaConfiguration(
    resourceArn: LambdaFunctionArn,
    invocationType: zio.aws.chimesdkmessaging.model.InvocationType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.LambdaConfiguration = {
    import LambdaConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.LambdaConfiguration
      .builder()
      .resourceArn(LambdaFunctionArn.unwrap(resourceArn): java.lang.String)
      .invocationType(invocationType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmessaging.model.LambdaConfiguration.ReadOnly =
    zio.aws.chimesdkmessaging.model.LambdaConfiguration.wrap(buildAwsValue())
}
object LambdaConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.LambdaConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.LambdaConfiguration =
      zio.aws.chimesdkmessaging.model
        .LambdaConfiguration(resourceArn, invocationType)
    def resourceArn: LambdaFunctionArn
    def invocationType: zio.aws.chimesdkmessaging.model.InvocationType
    def getResourceArn: ZIO[Any, Nothing, LambdaFunctionArn] =
      ZIO.succeed(resourceArn)
    def getInvocationType
        : ZIO[Any, Nothing, zio.aws.chimesdkmessaging.model.InvocationType] =
      ZIO.succeed(invocationType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.LambdaConfiguration
  ) extends zio.aws.chimesdkmessaging.model.LambdaConfiguration.ReadOnly {
    override val resourceArn: LambdaFunctionArn =
      zio.aws.chimesdkmessaging.model.primitives
        .LambdaFunctionArn(impl.resourceArn())
    override val invocationType
        : zio.aws.chimesdkmessaging.model.InvocationType =
      zio.aws.chimesdkmessaging.model.InvocationType.wrap(impl.invocationType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.LambdaConfiguration
  ): zio.aws.chimesdkmessaging.model.LambdaConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
