package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ChannelMembershipSummary(
    member: Optional[zio.aws.chimesdkmessaging.model.Identity] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMembershipSummary = {
    import ChannelMembershipSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMembershipSummary
      .builder()
      .optionallyWith(member.map(value => value.buildAwsValue()))(_.member)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ChannelMembershipSummary.ReadOnly =
    zio.aws.chimesdkmessaging.model.ChannelMembershipSummary
      .wrap(buildAwsValue())
}
object ChannelMembershipSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMembershipSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.ChannelMembershipSummary =
      zio.aws.chimesdkmessaging.model
        .ChannelMembershipSummary(member.map(value => value.asEditable))
    def member: Optional[zio.aws.chimesdkmessaging.model.Identity.ReadOnly]
    def getMember: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.Identity.ReadOnly
    ] = AwsError.unwrapOptionField("member", member)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMembershipSummary
  ) extends zio.aws.chimesdkmessaging.model.ChannelMembershipSummary.ReadOnly {
    override val member
        : Optional[zio.aws.chimesdkmessaging.model.Identity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.member())
        .map(value => zio.aws.chimesdkmessaging.model.Identity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMembershipSummary
  ): zio.aws.chimesdkmessaging.model.ChannelMembershipSummary.ReadOnly =
    new Wrapper(impl)
}
