package zio.aws.chimesdkmessaging.model
import zio.aws.chimesdkmessaging.model.primitives.{
  Timestamp,
  NonEmptyResourceName,
  ChimeArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ChannelFlow(
    channelFlowArn: Optional[ChimeArn] = Optional.Absent,
    processors: Optional[Iterable[zio.aws.chimesdkmessaging.model.Processor]] =
      Optional.Absent,
    name: Optional[NonEmptyResourceName] = Optional.Absent,
    createdTimestamp: Optional[Timestamp] = Optional.Absent,
    lastUpdatedTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlow = {
    import ChannelFlow.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlow
      .builder()
      .optionallyWith(
        channelFlowArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelFlowArn)
      .optionallyWith(
        processors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processors)
      .optionallyWith(
        name.map(value => NonEmptyResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        lastUpdatedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmessaging.model.ChannelFlow.ReadOnly =
    zio.aws.chimesdkmessaging.model.ChannelFlow.wrap(buildAwsValue())
}
object ChannelFlow {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlow
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.ChannelFlow =
      zio.aws.chimesdkmessaging.model.ChannelFlow(
        channelFlowArn.map(value => value),
        processors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name.map(value => value),
        createdTimestamp.map(value => value),
        lastUpdatedTimestamp.map(value => value)
      )
    def channelFlowArn: Optional[ChimeArn]
    def processors
        : Optional[List[zio.aws.chimesdkmessaging.model.Processor.ReadOnly]]
    def name: Optional[NonEmptyResourceName]
    def createdTimestamp: Optional[Timestamp]
    def lastUpdatedTimestamp: Optional[Timestamp]
    def getChannelFlowArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelFlowArn", channelFlowArn)
    def getProcessors: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmessaging.model.Processor.ReadOnly
    ]] = AwsError.unwrapOptionField("processors", processors)
    def getName: ZIO[Any, AwsError, NonEmptyResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getLastUpdatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlow
  ) extends zio.aws.chimesdkmessaging.model.ChannelFlow.ReadOnly {
    override val channelFlowArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelFlowArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val processors
        : Optional[List[zio.aws.chimesdkmessaging.model.Processor.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chimesdkmessaging.model.Processor.wrap(item)
          }.toList
        )
    override val name: Optional[NonEmptyResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.NonEmptyResourceName(value)
      )
    override val createdTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTimestamp())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Timestamp(value))
    override val lastUpdatedTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTimestamp())
        .map(value =>
          zio.aws.chimesdkmessaging.model.primitives.Timestamp(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlow
  ): zio.aws.chimesdkmessaging.model.ChannelFlow.ReadOnly = new Wrapper(impl)
}
