package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeChannelMembershipForAppInstanceUserResponse(
    channelMembership: Optional[
      zio.aws.chimesdkmessaging.model.ChannelMembershipForAppInstanceUserSummary
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelMembershipForAppInstanceUserResponse = {
    import DescribeChannelMembershipForAppInstanceUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelMembershipForAppInstanceUserResponse
      .builder()
      .optionallyWith(channelMembership.map(value => value.buildAwsValue()))(
        _.channelMembership
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.DescribeChannelMembershipForAppInstanceUserResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.DescribeChannelMembershipForAppInstanceUserResponse
      .wrap(buildAwsValue())
}
object DescribeChannelMembershipForAppInstanceUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelMembershipForAppInstanceUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.DescribeChannelMembershipForAppInstanceUserResponse =
      zio.aws.chimesdkmessaging.model
        .DescribeChannelMembershipForAppInstanceUserResponse(
          channelMembership.map(value => value.asEditable)
        )
    def channelMembership: Optional[
      zio.aws.chimesdkmessaging.model.ChannelMembershipForAppInstanceUserSummary.ReadOnly
    ]
    def getChannelMembership: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelMembershipForAppInstanceUserSummary.ReadOnly
    ] = AwsError.unwrapOptionField("channelMembership", channelMembership)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelMembershipForAppInstanceUserResponse
  ) extends zio.aws.chimesdkmessaging.model.DescribeChannelMembershipForAppInstanceUserResponse.ReadOnly {
    override val channelMembership: Optional[
      zio.aws.chimesdkmessaging.model.ChannelMembershipForAppInstanceUserSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.channelMembership())
      .map(value =>
        zio.aws.chimesdkmessaging.model.ChannelMembershipForAppInstanceUserSummary
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelMembershipForAppInstanceUserResponse
  ): zio.aws.chimesdkmessaging.model.DescribeChannelMembershipForAppInstanceUserResponse.ReadOnly =
    new Wrapper(impl)
}
