package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListChannelsResponse(
    channels: Optional[
      Iterable[zio.aws.chimesdkmessaging.model.ChannelSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelsResponse = {
    import ListChannelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelsResponse
      .builder()
      .optionallyWith(
        channels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.channels)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ListChannelsResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.ListChannelsResponse.wrap(buildAwsValue())
}
object ListChannelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.ListChannelsResponse =
      zio.aws.chimesdkmessaging.model.ListChannelsResponse(
        channels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def channels: Optional[
      List[zio.aws.chimesdkmessaging.model.ChannelSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getChannels: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmessaging.model.ChannelSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("channels", channels)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelsResponse
  ) extends zio.aws.chimesdkmessaging.model.ListChannelsResponse.ReadOnly {
    override val channels: Optional[
      List[zio.aws.chimesdkmessaging.model.ChannelSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.channels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkmessaging.model.ChannelSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelsResponse
  ): zio.aws.chimesdkmessaging.model.ListChannelsResponse.ReadOnly =
    new Wrapper(impl)
}
