package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetMessagingSessionEndpointResponse(
    endpoint: Optional[
      zio.aws.chimesdkmessaging.model.MessagingSessionEndpoint
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.GetMessagingSessionEndpointResponse = {
    import GetMessagingSessionEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.GetMessagingSessionEndpointResponse
      .builder()
      .optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.GetMessagingSessionEndpointResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.GetMessagingSessionEndpointResponse
      .wrap(buildAwsValue())
}
object GetMessagingSessionEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.GetMessagingSessionEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.GetMessagingSessionEndpointResponse =
      zio.aws.chimesdkmessaging.model.GetMessagingSessionEndpointResponse(
        endpoint.map(value => value.asEditable)
      )
    def endpoint: Optional[
      zio.aws.chimesdkmessaging.model.MessagingSessionEndpoint.ReadOnly
    ]
    def getEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.MessagingSessionEndpoint.ReadOnly
    ] = AwsError.unwrapOptionField("endpoint", endpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.GetMessagingSessionEndpointResponse
  ) extends zio.aws.chimesdkmessaging.model.GetMessagingSessionEndpointResponse.ReadOnly {
    override val endpoint: Optional[
      zio.aws.chimesdkmessaging.model.MessagingSessionEndpoint.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoint())
      .map(value =>
        zio.aws.chimesdkmessaging.model.MessagingSessionEndpoint.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.GetMessagingSessionEndpointResponse
  ): zio.aws.chimesdkmessaging.model.GetMessagingSessionEndpointResponse.ReadOnly =
    new Wrapper(impl)
}
