package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmessaging.model.primitives.ChimeArn
import scala.jdk.CollectionConverters._
final case class DeleteChannelMembershipRequest(
    channelArn: ChimeArn,
    memberArn: ChimeArn,
    chimeBearer: ChimeArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.DeleteChannelMembershipRequest = {
    import DeleteChannelMembershipRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.DeleteChannelMembershipRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .memberArn(ChimeArn.unwrap(memberArn): java.lang.String)
      .chimeBearer(ChimeArn.unwrap(chimeBearer): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.DeleteChannelMembershipRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.DeleteChannelMembershipRequest
      .wrap(buildAwsValue())
}
object DeleteChannelMembershipRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.DeleteChannelMembershipRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.DeleteChannelMembershipRequest =
      zio.aws.chimesdkmessaging.model
        .DeleteChannelMembershipRequest(channelArn, memberArn, chimeBearer)
    def channelArn: ChimeArn
    def memberArn: ChimeArn
    def chimeBearer: ChimeArn
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getMemberArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(memberArn)
    def getChimeBearer: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.DeleteChannelMembershipRequest
  ) extends zio.aws.chimesdkmessaging.model.DeleteChannelMembershipRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.channelArn())
    override val memberArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.memberArn())
    override val chimeBearer: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.chimeBearer())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.DeleteChannelMembershipRequest
  ): zio.aws.chimesdkmessaging.model.DeleteChannelMembershipRequest.ReadOnly =
    new Wrapper(impl)
}
