package zio.aws.chimesdkmessaging
import zio.aws.chimesdkmessaging.model.ListTagsForResourceResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.chimesdkmessaging.{
  ChimeSdkMessagingAsyncClientBuilder,
  ChimeSdkMessagingAsyncClient
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.chimesdkmessaging.model.{
  ListChannelBansRequest,
  ListChannelFlowsRequest,
  DescribeChannelMembershipForAppInstanceUserResponse,
  ChannelFlowCallbackResponse,
  CreateChannelResponse,
  ListChannelsModeratedByAppInstanceUserResponse,
  DeleteChannelModeratorRequest,
  DisassociateChannelFlowResponse,
  BatchCreateChannelMembershipRequest,
  UpdateChannelReadMarkerRequest,
  ListChannelMessagesRequest,
  UpdateChannelResponse,
  GetChannelMessageRequest,
  ChannelMessageSummary,
  RedactChannelMessageRequest,
  ListChannelModeratorsResponse,
  ListChannelsAssociatedWithChannelFlowResponse,
  ListChannelsResponse,
  DeleteChannelRequest,
  ChannelFlowCallbackRequest,
  DescribeChannelModeratedByAppInstanceUserResponse,
  DescribeChannelResponse,
  ChannelModeratorSummary,
  ChannelBanSummary,
  DeleteChannelMembershipRequest,
  DisassociateChannelFlowRequest,
  DescribeChannelModeratedByAppInstanceUserRequest,
  GetChannelMembershipPreferencesResponse,
  DeleteChannelFlowResponse,
  CreateChannelRequest,
  DescribeChannelMembershipRequest,
  DeleteChannelFlowRequest,
  ChannelMembershipSummary,
  DeleteChannelBanResponse,
  UpdateChannelMessageResponse,
  ListTagsForResourceRequest,
  ListChannelMessagesResponse,
  UpdateChannelMessageRequest,
  ListChannelMembershipsForAppInstanceUserResponse,
  PutChannelMembershipPreferencesRequest,
  CreateChannelMembershipRequest,
  BatchCreateChannelMembershipResponse,
  ChannelModeratedByAppInstanceUserSummary,
  GetChannelMessageStatusResponse,
  UpdateChannelFlowResponse,
  DeleteChannelMessageResponse,
  DescribeChannelFlowRequest,
  DescribeChannelMembershipResponse,
  ChannelSummary,
  ListChannelMembershipsResponse,
  ListChannelMembershipsForAppInstanceUserRequest,
  ListChannelsAssociatedWithChannelFlowRequest,
  ListTagsForResourceResponse,
  DeleteChannelBanRequest,
  UntagResourceResponse,
  UpdateChannelFlowRequest,
  ListChannelFlowsResponse,
  DescribeChannelMembershipForAppInstanceUserRequest,
  CreateChannelFlowRequest,
  DescribeChannelModeratorResponse,
  UpdateChannelRequest,
  DeleteChannelModeratorResponse,
  ListChannelBansResponse,
  DescribeChannelBanRequest,
  DeleteChannelMembershipResponse,
  AssociateChannelFlowRequest,
  SendChannelMessageResponse,
  GetChannelMembershipPreferencesRequest,
  GetMessagingSessionEndpointResponse,
  ListChannelsRequest,
  ListChannelModeratorsRequest,
  SendChannelMessageRequest,
  UntagResourceRequest,
  GetChannelMessageResponse,
  RedactChannelMessageResponse,
  PutChannelMembershipPreferencesResponse,
  CreateChannelBanRequest,
  DescribeChannelBanResponse,
  CreateChannelFlowResponse,
  ChannelAssociatedWithFlowSummary,
  GetMessagingSessionEndpointRequest,
  DeleteChannelMessageRequest,
  UpdateChannelReadMarkerResponse,
  CreateChannelMembershipResponse,
  CreateChannelBanResponse,
  TagResourceResponse,
  GetChannelMessageStatusRequest,
  DescribeChannelRequest,
  DescribeChannelFlowResponse,
  DeleteChannelResponse,
  AssociateChannelFlowResponse,
  CreateChannelModeratorRequest,
  ChannelFlowSummary,
  TagResourceRequest,
  DescribeChannelModeratorRequest,
  CreateChannelModeratorResponse,
  ListChannelMembershipsRequest,
  ChannelMembershipForAppInstanceUserSummary,
  ListChannelsModeratedByAppInstanceUserRequest
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait ChimeSdkMessaging extends AspectSupport[ChimeSdkMessaging] {
  val api: ChimeSdkMessagingAsyncClient
  def describeChannelMembership(
      request: zio.aws.chimesdkmessaging.model.DescribeChannelMembershipRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.DescribeChannelMembershipResponse.ReadOnly
  ]
  def listChannels(
      request: zio.aws.chimesdkmessaging.model.ListChannelsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.chimesdkmessaging.model.ChannelSummary.ReadOnly
  ]
  def listChannelsPaginated(
      request: zio.aws.chimesdkmessaging.model.ListChannelsRequest
  ): IO[AwsError, zio.aws.chimesdkmessaging.model.ListChannelsResponse.ReadOnly]
  def channelFlowCallback(
      request: zio.aws.chimesdkmessaging.model.ChannelFlowCallbackRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.ChannelFlowCallbackResponse.ReadOnly
  ]
  def listChannelsAssociatedWithChannelFlow(
      request: zio.aws.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.chimesdkmessaging.model.ChannelAssociatedWithFlowSummary.ReadOnly
  ]
  def listChannelsAssociatedWithChannelFlowPaginated(
      request: zio.aws.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowResponse.ReadOnly
  ]
  def deleteChannelModerator(
      request: zio.aws.chimesdkmessaging.model.DeleteChannelModeratorRequest
  ): IO[AwsError, Unit]
  def describeChannelModeratedByAppInstanceUser(
      request: zio.aws.chimesdkmessaging.model.DescribeChannelModeratedByAppInstanceUserRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.DescribeChannelModeratedByAppInstanceUserResponse.ReadOnly
  ]
  def listChannelMembershipsForAppInstanceUser(
      request: zio.aws.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.chimesdkmessaging.model.ChannelMembershipForAppInstanceUserSummary.ReadOnly
  ]
  def listChannelMembershipsForAppInstanceUserPaginated(
      request: zio.aws.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserResponse.ReadOnly
  ]
  def sendChannelMessage(
      request: zio.aws.chimesdkmessaging.model.SendChannelMessageRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.SendChannelMessageResponse.ReadOnly
  ]
  def deleteChannelMembership(
      request: zio.aws.chimesdkmessaging.model.DeleteChannelMembershipRequest
  ): IO[AwsError, Unit]
  def putChannelMembershipPreferences(
      request: zio.aws.chimesdkmessaging.model.PutChannelMembershipPreferencesRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.PutChannelMembershipPreferencesResponse.ReadOnly
  ]
  def listChannelFlows(
      request: zio.aws.chimesdkmessaging.model.ListChannelFlowsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.chimesdkmessaging.model.ChannelFlowSummary.ReadOnly
  ]
  def listChannelFlowsPaginated(
      request: zio.aws.chimesdkmessaging.model.ListChannelFlowsRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.ListChannelFlowsResponse.ReadOnly
  ]
  def deleteChannel(
      request: zio.aws.chimesdkmessaging.model.DeleteChannelRequest
  ): IO[AwsError, Unit]
  def listChannelBans(
      request: zio.aws.chimesdkmessaging.model.ListChannelBansRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.chimesdkmessaging.model.ListChannelBansResponse.ReadOnly,
    zio.aws.chimesdkmessaging.model.ChannelBanSummary.ReadOnly
  ]]
  def listChannelBansPaginated(
      request: zio.aws.chimesdkmessaging.model.ListChannelBansRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.ListChannelBansResponse.ReadOnly
  ]
  def listChannelMessages(
      request: zio.aws.chimesdkmessaging.model.ListChannelMessagesRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.chimesdkmessaging.model.ListChannelMessagesResponse.ReadOnly,
    zio.aws.chimesdkmessaging.model.ChannelMessageSummary.ReadOnly
  ]]
  def listChannelMessagesPaginated(
      request: zio.aws.chimesdkmessaging.model.ListChannelMessagesRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.ListChannelMessagesResponse.ReadOnly
  ]
  def associateChannelFlow(
      request: zio.aws.chimesdkmessaging.model.AssociateChannelFlowRequest
  ): IO[AwsError, Unit]
  def deleteChannelFlow(
      request: zio.aws.chimesdkmessaging.model.DeleteChannelFlowRequest
  ): IO[AwsError, Unit]
  def createChannelMembership(
      request: zio.aws.chimesdkmessaging.model.CreateChannelMembershipRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.CreateChannelMembershipResponse.ReadOnly
  ]
  def createChannel(
      request: zio.aws.chimesdkmessaging.model.CreateChannelRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.CreateChannelResponse.ReadOnly
  ]
  def describeChannelBan(
      request: zio.aws.chimesdkmessaging.model.DescribeChannelBanRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.DescribeChannelBanResponse.ReadOnly
  ]
  def listChannelMemberships(
      request: zio.aws.chimesdkmessaging.model.ListChannelMembershipsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.chimesdkmessaging.model.ListChannelMembershipsResponse.ReadOnly,
    zio.aws.chimesdkmessaging.model.ChannelMembershipSummary.ReadOnly
  ]]
  def listChannelMembershipsPaginated(
      request: zio.aws.chimesdkmessaging.model.ListChannelMembershipsRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.ListChannelMembershipsResponse.ReadOnly
  ]
  def batchCreateChannelMembership(
      request: zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipResponse.ReadOnly
  ]
  def updateChannelFlow(
      request: zio.aws.chimesdkmessaging.model.UpdateChannelFlowRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.UpdateChannelFlowResponse.ReadOnly
  ]
  def updateChannelReadMarker(
      request: zio.aws.chimesdkmessaging.model.UpdateChannelReadMarkerRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.UpdateChannelReadMarkerResponse.ReadOnly
  ]
  def createChannelModerator(
      request: zio.aws.chimesdkmessaging.model.CreateChannelModeratorRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.CreateChannelModeratorResponse.ReadOnly
  ]
  def untagResource(
      request: zio.aws.chimesdkmessaging.model.UntagResourceRequest
  ): IO[AwsError, Unit]
  def getChannelMessage(
      request: zio.aws.chimesdkmessaging.model.GetChannelMessageRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.GetChannelMessageResponse.ReadOnly
  ]
  def createChannelBan(
      request: zio.aws.chimesdkmessaging.model.CreateChannelBanRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.CreateChannelBanResponse.ReadOnly
  ]
  def deleteChannelMessage(
      request: zio.aws.chimesdkmessaging.model.DeleteChannelMessageRequest
  ): IO[AwsError, Unit]
  def redactChannelMessage(
      request: zio.aws.chimesdkmessaging.model.RedactChannelMessageRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.RedactChannelMessageResponse.ReadOnly
  ]
  def deleteChannelBan(
      request: zio.aws.chimesdkmessaging.model.DeleteChannelBanRequest
  ): IO[AwsError, Unit]
  def describeChannelModerator(
      request: zio.aws.chimesdkmessaging.model.DescribeChannelModeratorRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.DescribeChannelModeratorResponse.ReadOnly
  ]
  def describeChannelMembershipForAppInstanceUser(
      request: zio.aws.chimesdkmessaging.model.DescribeChannelMembershipForAppInstanceUserRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.DescribeChannelMembershipForAppInstanceUserResponse.ReadOnly
  ]
  def listTagsForResource(
      request: zio.aws.chimesdkmessaging.model.ListTagsForResourceRequest
  ): IO[AwsError, ReadOnly]
  def disassociateChannelFlow(
      request: zio.aws.chimesdkmessaging.model.DisassociateChannelFlowRequest
  ): IO[AwsError, Unit]
  def getChannelMembershipPreferences(
      request: zio.aws.chimesdkmessaging.model.GetChannelMembershipPreferencesRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.GetChannelMembershipPreferencesResponse.ReadOnly
  ]
  def tagResource(
      request: zio.aws.chimesdkmessaging.model.TagResourceRequest
  ): IO[AwsError, Unit]
  def describeChannel(
      request: zio.aws.chimesdkmessaging.model.DescribeChannelRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.DescribeChannelResponse.ReadOnly
  ]
  def createChannelFlow(
      request: zio.aws.chimesdkmessaging.model.CreateChannelFlowRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.CreateChannelFlowResponse.ReadOnly
  ]
  def listChannelModerators(
      request: zio.aws.chimesdkmessaging.model.ListChannelModeratorsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.chimesdkmessaging.model.ListChannelModeratorsResponse.ReadOnly,
    zio.aws.chimesdkmessaging.model.ChannelModeratorSummary.ReadOnly
  ]]
  def listChannelModeratorsPaginated(
      request: zio.aws.chimesdkmessaging.model.ListChannelModeratorsRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.ListChannelModeratorsResponse.ReadOnly
  ]
  def getChannelMessageStatus(
      request: zio.aws.chimesdkmessaging.model.GetChannelMessageStatusRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.GetChannelMessageStatusResponse.ReadOnly
  ]
  def listChannelsModeratedByAppInstanceUser(
      request: zio.aws.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.chimesdkmessaging.model.ChannelModeratedByAppInstanceUserSummary.ReadOnly
  ]
  def listChannelsModeratedByAppInstanceUserPaginated(
      request: zio.aws.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserResponse.ReadOnly
  ]
  def updateChannelMessage(
      request: zio.aws.chimesdkmessaging.model.UpdateChannelMessageRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.UpdateChannelMessageResponse.ReadOnly
  ]
  def getMessagingSessionEndpoint(
      request: zio.aws.chimesdkmessaging.model.GetMessagingSessionEndpointRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.GetMessagingSessionEndpointResponse.ReadOnly
  ]
  def updateChannel(
      request: zio.aws.chimesdkmessaging.model.UpdateChannelRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.UpdateChannelResponse.ReadOnly
  ]
  def describeChannelFlow(
      request: zio.aws.chimesdkmessaging.model.DescribeChannelFlowRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmessaging.model.DescribeChannelFlowResponse.ReadOnly
  ]
}
object ChimeSdkMessaging {
  val live: ZLayer[AwsConfig, java.lang.Throwable, ChimeSdkMessaging] =
    customized(identity)
  def customized(
      customization: ChimeSdkMessagingAsyncClientBuilder => ChimeSdkMessagingAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, ChimeSdkMessaging] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: ChimeSdkMessagingAsyncClientBuilder => ChimeSdkMessagingAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, ChimeSdkMessaging] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = ChimeSdkMessagingAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      ChimeSdkMessagingAsyncClient,
      ChimeSdkMessagingAsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      ChimeSdkMessagingAsyncClient,
      ChimeSdkMessagingAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new ChimeSdkMessagingImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class ChimeSdkMessagingImpl[R](
      override val api: ChimeSdkMessagingAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends ChimeSdkMessaging
      with AwsServiceBase[R] {
    override val serviceName: String = "ChimeSdkMessaging"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ChimeSdkMessagingImpl[R1] = new ChimeSdkMessagingImpl(api, newAspect, r)
    def describeChannelMembership(
        request: zio.aws.chimesdkmessaging.model.DescribeChannelMembershipRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.DescribeChannelMembershipResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeChannelMembershipRequest,
      DescribeChannelMembershipResponse
    ]("describeChannelMembership", api.describeChannelMembership)(
      request.buildAwsValue()
    ).map(
      zio.aws.chimesdkmessaging.model.DescribeChannelMembershipResponse.wrap
    ).provideEnvironment(r)
    def listChannels(
        request: zio.aws.chimesdkmessaging.model.ListChannelsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListChannelsRequest,
      ListChannelsResponse,
      ChannelSummary
    ](
      "listChannels",
      api.listChannels,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.channels().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.chimesdkmessaging.model.ChannelSummary.wrap(item))
      .provideEnvironment(r)
    def listChannelsPaginated(
        request: zio.aws.chimesdkmessaging.model.ListChannelsRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.ListChannelsResponse.ReadOnly
    ] = asyncRequestResponse[ListChannelsRequest, ListChannelsResponse](
      "listChannels",
      api.listChannels
    )(request.buildAwsValue())
      .map(zio.aws.chimesdkmessaging.model.ListChannelsResponse.wrap)
      .provideEnvironment(r)
    def channelFlowCallback(
        request: zio.aws.chimesdkmessaging.model.ChannelFlowCallbackRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelFlowCallbackResponse.ReadOnly
    ] = asyncRequestResponse[
      ChannelFlowCallbackRequest,
      ChannelFlowCallbackResponse
    ]("channelFlowCallback", api.channelFlowCallback)(request.buildAwsValue())
      .map(zio.aws.chimesdkmessaging.model.ChannelFlowCallbackResponse.wrap)
      .provideEnvironment(r)
    def listChannelsAssociatedWithChannelFlow(
        request: zio.aws.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelAssociatedWithFlowSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListChannelsAssociatedWithChannelFlowRequest,
      ListChannelsAssociatedWithChannelFlowResponse,
      ChannelAssociatedWithFlowSummary
    ](
      "listChannelsAssociatedWithChannelFlow",
      api.listChannelsAssociatedWithChannelFlow,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.channels().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.chimesdkmessaging.model.ChannelAssociatedWithFlowSummary
          .wrap(item)
      )
      .provideEnvironment(r)
    def listChannelsAssociatedWithChannelFlowPaginated(
        request: zio.aws.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowResponse.ReadOnly
    ] = asyncRequestResponse[
      ListChannelsAssociatedWithChannelFlowRequest,
      ListChannelsAssociatedWithChannelFlowResponse
    ](
      "listChannelsAssociatedWithChannelFlow",
      api.listChannelsAssociatedWithChannelFlow
    )(request.buildAwsValue())
      .map(
        zio.aws.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowResponse.wrap
      )
      .provideEnvironment(r)
    def deleteChannelModerator(
        request: zio.aws.chimesdkmessaging.model.DeleteChannelModeratorRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteChannelModeratorRequest,
      DeleteChannelModeratorResponse
    ]("deleteChannelModerator", api.deleteChannelModerator)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeChannelModeratedByAppInstanceUser(
        request: zio.aws.chimesdkmessaging.model.DescribeChannelModeratedByAppInstanceUserRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.DescribeChannelModeratedByAppInstanceUserResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeChannelModeratedByAppInstanceUserRequest,
      DescribeChannelModeratedByAppInstanceUserResponse
    ](
      "describeChannelModeratedByAppInstanceUser",
      api.describeChannelModeratedByAppInstanceUser
    )(request.buildAwsValue())
      .map(
        zio.aws.chimesdkmessaging.model.DescribeChannelModeratedByAppInstanceUserResponse.wrap
      )
      .provideEnvironment(r)
    def listChannelMembershipsForAppInstanceUser(
        request: zio.aws.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelMembershipForAppInstanceUserSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListChannelMembershipsForAppInstanceUserRequest,
      ListChannelMembershipsForAppInstanceUserResponse,
      ChannelMembershipForAppInstanceUserSummary
    ](
      "listChannelMembershipsForAppInstanceUser",
      api.listChannelMembershipsForAppInstanceUser,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.channelMemberships().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.chimesdkmessaging.model.ChannelMembershipForAppInstanceUserSummary
          .wrap(item)
      )
      .provideEnvironment(r)
    def listChannelMembershipsForAppInstanceUserPaginated(
        request: zio.aws.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserResponse.ReadOnly
    ] = asyncRequestResponse[
      ListChannelMembershipsForAppInstanceUserRequest,
      ListChannelMembershipsForAppInstanceUserResponse
    ](
      "listChannelMembershipsForAppInstanceUser",
      api.listChannelMembershipsForAppInstanceUser
    )(request.buildAwsValue())
      .map(
        zio.aws.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserResponse.wrap
      )
      .provideEnvironment(r)
    def sendChannelMessage(
        request: zio.aws.chimesdkmessaging.model.SendChannelMessageRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.SendChannelMessageResponse.ReadOnly
    ] = asyncRequestResponse[
      SendChannelMessageRequest,
      SendChannelMessageResponse
    ]("sendChannelMessage", api.sendChannelMessage)(request.buildAwsValue())
      .map(zio.aws.chimesdkmessaging.model.SendChannelMessageResponse.wrap)
      .provideEnvironment(r)
    def deleteChannelMembership(
        request: zio.aws.chimesdkmessaging.model.DeleteChannelMembershipRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteChannelMembershipRequest,
      DeleteChannelMembershipResponse
    ]("deleteChannelMembership", api.deleteChannelMembership)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putChannelMembershipPreferences(
        request: zio.aws.chimesdkmessaging.model.PutChannelMembershipPreferencesRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.PutChannelMembershipPreferencesResponse.ReadOnly
    ] = asyncRequestResponse[
      PutChannelMembershipPreferencesRequest,
      PutChannelMembershipPreferencesResponse
    ]("putChannelMembershipPreferences", api.putChannelMembershipPreferences)(
      request.buildAwsValue()
    ).map(
      zio.aws.chimesdkmessaging.model.PutChannelMembershipPreferencesResponse.wrap
    ).provideEnvironment(r)
    def listChannelFlows(
        request: zio.aws.chimesdkmessaging.model.ListChannelFlowsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelFlowSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListChannelFlowsRequest,
      ListChannelFlowsResponse,
      ChannelFlowSummary
    ](
      "listChannelFlows",
      api.listChannelFlows,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.channelFlows().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.chimesdkmessaging.model.ChannelFlowSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listChannelFlowsPaginated(
        request: zio.aws.chimesdkmessaging.model.ListChannelFlowsRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.ListChannelFlowsResponse.ReadOnly
    ] = asyncRequestResponse[ListChannelFlowsRequest, ListChannelFlowsResponse](
      "listChannelFlows",
      api.listChannelFlows
    )(request.buildAwsValue())
      .map(zio.aws.chimesdkmessaging.model.ListChannelFlowsResponse.wrap)
      .provideEnvironment(r)
    def deleteChannel(
        request: zio.aws.chimesdkmessaging.model.DeleteChannelRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteChannelRequest, DeleteChannelResponse](
        "deleteChannel",
        api.deleteChannel
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def listChannelBans(
        request: zio.aws.chimesdkmessaging.model.ListChannelBansRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.chimesdkmessaging.model.ListChannelBansResponse.ReadOnly,
      zio.aws.chimesdkmessaging.model.ChannelBanSummary.ReadOnly
    ]] = asyncPaginatedRequest[
      ListChannelBansRequest,
      ListChannelBansResponse,
      ChannelBanSummary
    ](
      "listChannelBans",
      api.listChannelBans,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.channelBans().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.chimesdkmessaging.model.ListChannelBansResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.chimesdkmessaging.model.ChannelBanSummary.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listChannelBansPaginated(
        request: zio.aws.chimesdkmessaging.model.ListChannelBansRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.ListChannelBansResponse.ReadOnly
    ] = asyncRequestResponse[ListChannelBansRequest, ListChannelBansResponse](
      "listChannelBans",
      api.listChannelBans
    )(request.buildAwsValue())
      .map(zio.aws.chimesdkmessaging.model.ListChannelBansResponse.wrap)
      .provideEnvironment(r)
    def listChannelMessages(
        request: zio.aws.chimesdkmessaging.model.ListChannelMessagesRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.chimesdkmessaging.model.ListChannelMessagesResponse.ReadOnly,
      zio.aws.chimesdkmessaging.model.ChannelMessageSummary.ReadOnly
    ]] = asyncPaginatedRequest[
      ListChannelMessagesRequest,
      ListChannelMessagesResponse,
      ChannelMessageSummary
    ](
      "listChannelMessages",
      api.listChannelMessages,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.channelMessages().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.chimesdkmessaging.model.ListChannelMessagesResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.chimesdkmessaging.model.ChannelMessageSummary.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listChannelMessagesPaginated(
        request: zio.aws.chimesdkmessaging.model.ListChannelMessagesRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.ListChannelMessagesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListChannelMessagesRequest,
      ListChannelMessagesResponse
    ]("listChannelMessages", api.listChannelMessages)(request.buildAwsValue())
      .map(zio.aws.chimesdkmessaging.model.ListChannelMessagesResponse.wrap)
      .provideEnvironment(r)
    def associateChannelFlow(
        request: zio.aws.chimesdkmessaging.model.AssociateChannelFlowRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      AssociateChannelFlowRequest,
      AssociateChannelFlowResponse
    ]("associateChannelFlow", api.associateChannelFlow)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteChannelFlow(
        request: zio.aws.chimesdkmessaging.model.DeleteChannelFlowRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteChannelFlowRequest, DeleteChannelFlowResponse](
        "deleteChannelFlow",
        api.deleteChannelFlow
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createChannelMembership(
        request: zio.aws.chimesdkmessaging.model.CreateChannelMembershipRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.CreateChannelMembershipResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateChannelMembershipRequest,
      CreateChannelMembershipResponse
    ]("createChannelMembership", api.createChannelMembership)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkmessaging.model.CreateChannelMembershipResponse.wrap)
      .provideEnvironment(r)
    def createChannel(
        request: zio.aws.chimesdkmessaging.model.CreateChannelRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.CreateChannelResponse.ReadOnly
    ] = asyncRequestResponse[CreateChannelRequest, CreateChannelResponse](
      "createChannel",
      api.createChannel
    )(request.buildAwsValue())
      .map(zio.aws.chimesdkmessaging.model.CreateChannelResponse.wrap)
      .provideEnvironment(r)
    def describeChannelBan(
        request: zio.aws.chimesdkmessaging.model.DescribeChannelBanRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.DescribeChannelBanResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeChannelBanRequest,
      DescribeChannelBanResponse
    ]("describeChannelBan", api.describeChannelBan)(request.buildAwsValue())
      .map(zio.aws.chimesdkmessaging.model.DescribeChannelBanResponse.wrap)
      .provideEnvironment(r)
    def listChannelMemberships(
        request: zio.aws.chimesdkmessaging.model.ListChannelMembershipsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.chimesdkmessaging.model.ListChannelMembershipsResponse.ReadOnly,
      zio.aws.chimesdkmessaging.model.ChannelMembershipSummary.ReadOnly
    ]] = asyncPaginatedRequest[
      ListChannelMembershipsRequest,
      ListChannelMembershipsResponse,
      ChannelMembershipSummary
    ](
      "listChannelMemberships",
      api.listChannelMemberships,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.channelMemberships().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.chimesdkmessaging.model.ListChannelMembershipsResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.chimesdkmessaging.model.ChannelMembershipSummary
                .wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listChannelMembershipsPaginated(
        request: zio.aws.chimesdkmessaging.model.ListChannelMembershipsRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.ListChannelMembershipsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListChannelMembershipsRequest,
      ListChannelMembershipsResponse
    ]("listChannelMemberships", api.listChannelMemberships)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkmessaging.model.ListChannelMembershipsResponse.wrap)
      .provideEnvironment(r)
    def batchCreateChannelMembership(
        request: zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchCreateChannelMembershipRequest,
      BatchCreateChannelMembershipResponse
    ]("batchCreateChannelMembership", api.batchCreateChannelMembership)(
      request.buildAwsValue()
    ).map(
      zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipResponse.wrap
    ).provideEnvironment(r)
    def updateChannelFlow(
        request: zio.aws.chimesdkmessaging.model.UpdateChannelFlowRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.UpdateChannelFlowResponse.ReadOnly
    ] =
      asyncRequestResponse[UpdateChannelFlowRequest, UpdateChannelFlowResponse](
        "updateChannelFlow",
        api.updateChannelFlow
      )(request.buildAwsValue())
        .map(zio.aws.chimesdkmessaging.model.UpdateChannelFlowResponse.wrap)
        .provideEnvironment(r)
    def updateChannelReadMarker(
        request: zio.aws.chimesdkmessaging.model.UpdateChannelReadMarkerRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.UpdateChannelReadMarkerResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateChannelReadMarkerRequest,
      UpdateChannelReadMarkerResponse
    ]("updateChannelReadMarker", api.updateChannelReadMarker)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkmessaging.model.UpdateChannelReadMarkerResponse.wrap)
      .provideEnvironment(r)
    def createChannelModerator(
        request: zio.aws.chimesdkmessaging.model.CreateChannelModeratorRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.CreateChannelModeratorResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateChannelModeratorRequest,
      CreateChannelModeratorResponse
    ]("createChannelModerator", api.createChannelModerator)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkmessaging.model.CreateChannelModeratorResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: zio.aws.chimesdkmessaging.model.UntagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getChannelMessage(
        request: zio.aws.chimesdkmessaging.model.GetChannelMessageRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.GetChannelMessageResponse.ReadOnly
    ] =
      asyncRequestResponse[GetChannelMessageRequest, GetChannelMessageResponse](
        "getChannelMessage",
        api.getChannelMessage
      )(request.buildAwsValue())
        .map(zio.aws.chimesdkmessaging.model.GetChannelMessageResponse.wrap)
        .provideEnvironment(r)
    def createChannelBan(
        request: zio.aws.chimesdkmessaging.model.CreateChannelBanRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.CreateChannelBanResponse.ReadOnly
    ] = asyncRequestResponse[CreateChannelBanRequest, CreateChannelBanResponse](
      "createChannelBan",
      api.createChannelBan
    )(request.buildAwsValue())
      .map(zio.aws.chimesdkmessaging.model.CreateChannelBanResponse.wrap)
      .provideEnvironment(r)
    def deleteChannelMessage(
        request: zio.aws.chimesdkmessaging.model.DeleteChannelMessageRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteChannelMessageRequest,
      DeleteChannelMessageResponse
    ]("deleteChannelMessage", api.deleteChannelMessage)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def redactChannelMessage(
        request: zio.aws.chimesdkmessaging.model.RedactChannelMessageRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.RedactChannelMessageResponse.ReadOnly
    ] = asyncRequestResponse[
      RedactChannelMessageRequest,
      RedactChannelMessageResponse
    ]("redactChannelMessage", api.redactChannelMessage)(request.buildAwsValue())
      .map(zio.aws.chimesdkmessaging.model.RedactChannelMessageResponse.wrap)
      .provideEnvironment(r)
    def deleteChannelBan(
        request: zio.aws.chimesdkmessaging.model.DeleteChannelBanRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteChannelBanRequest, DeleteChannelBanResponse](
        "deleteChannelBan",
        api.deleteChannelBan
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def describeChannelModerator(
        request: zio.aws.chimesdkmessaging.model.DescribeChannelModeratorRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.DescribeChannelModeratorResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeChannelModeratorRequest,
      DescribeChannelModeratorResponse
    ]("describeChannelModerator", api.describeChannelModerator)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkmessaging.model.DescribeChannelModeratorResponse.wrap)
      .provideEnvironment(r)
    def describeChannelMembershipForAppInstanceUser(
        request: zio.aws.chimesdkmessaging.model.DescribeChannelMembershipForAppInstanceUserRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.DescribeChannelMembershipForAppInstanceUserResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeChannelMembershipForAppInstanceUserRequest,
      DescribeChannelMembershipForAppInstanceUserResponse
    ](
      "describeChannelMembershipForAppInstanceUser",
      api.describeChannelMembershipForAppInstanceUser
    )(request.buildAwsValue())
      .map(
        zio.aws.chimesdkmessaging.model.DescribeChannelMembershipForAppInstanceUserResponse.wrap
      )
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.chimesdkmessaging.model.ListTagsForResourceRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.chimesdkmessaging.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def disassociateChannelFlow(
        request: zio.aws.chimesdkmessaging.model.DisassociateChannelFlowRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DisassociateChannelFlowRequest,
      DisassociateChannelFlowResponse
    ]("disassociateChannelFlow", api.disassociateChannelFlow)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getChannelMembershipPreferences(
        request: zio.aws.chimesdkmessaging.model.GetChannelMembershipPreferencesRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.GetChannelMembershipPreferencesResponse.ReadOnly
    ] = asyncRequestResponse[
      GetChannelMembershipPreferencesRequest,
      GetChannelMembershipPreferencesResponse
    ]("getChannelMembershipPreferences", api.getChannelMembershipPreferences)(
      request.buildAwsValue()
    ).map(
      zio.aws.chimesdkmessaging.model.GetChannelMembershipPreferencesResponse.wrap
    ).provideEnvironment(r)
    def tagResource(
        request: zio.aws.chimesdkmessaging.model.TagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def describeChannel(
        request: zio.aws.chimesdkmessaging.model.DescribeChannelRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.DescribeChannelResponse.ReadOnly
    ] = asyncRequestResponse[DescribeChannelRequest, DescribeChannelResponse](
      "describeChannel",
      api.describeChannel
    )(request.buildAwsValue())
      .map(zio.aws.chimesdkmessaging.model.DescribeChannelResponse.wrap)
      .provideEnvironment(r)
    def createChannelFlow(
        request: zio.aws.chimesdkmessaging.model.CreateChannelFlowRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.CreateChannelFlowResponse.ReadOnly
    ] =
      asyncRequestResponse[CreateChannelFlowRequest, CreateChannelFlowResponse](
        "createChannelFlow",
        api.createChannelFlow
      )(request.buildAwsValue())
        .map(zio.aws.chimesdkmessaging.model.CreateChannelFlowResponse.wrap)
        .provideEnvironment(r)
    def listChannelModerators(
        request: zio.aws.chimesdkmessaging.model.ListChannelModeratorsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.chimesdkmessaging.model.ListChannelModeratorsResponse.ReadOnly,
      zio.aws.chimesdkmessaging.model.ChannelModeratorSummary.ReadOnly
    ]] = asyncPaginatedRequest[
      ListChannelModeratorsRequest,
      ListChannelModeratorsResponse,
      ChannelModeratorSummary
    ](
      "listChannelModerators",
      api.listChannelModerators,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.channelModerators().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.chimesdkmessaging.model.ListChannelModeratorsResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.chimesdkmessaging.model.ChannelModeratorSummary.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listChannelModeratorsPaginated(
        request: zio.aws.chimesdkmessaging.model.ListChannelModeratorsRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.ListChannelModeratorsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListChannelModeratorsRequest,
      ListChannelModeratorsResponse
    ]("listChannelModerators", api.listChannelModerators)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkmessaging.model.ListChannelModeratorsResponse.wrap)
      .provideEnvironment(r)
    def getChannelMessageStatus(
        request: zio.aws.chimesdkmessaging.model.GetChannelMessageStatusRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.GetChannelMessageStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      GetChannelMessageStatusRequest,
      GetChannelMessageStatusResponse
    ]("getChannelMessageStatus", api.getChannelMessageStatus)(
      request.buildAwsValue()
    ).map(zio.aws.chimesdkmessaging.model.GetChannelMessageStatusResponse.wrap)
      .provideEnvironment(r)
    def listChannelsModeratedByAppInstanceUser(
        request: zio.aws.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelModeratedByAppInstanceUserSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListChannelsModeratedByAppInstanceUserRequest,
      ListChannelsModeratedByAppInstanceUserResponse,
      ChannelModeratedByAppInstanceUserSummary
    ](
      "listChannelsModeratedByAppInstanceUser",
      api.listChannelsModeratedByAppInstanceUser,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.channels().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.chimesdkmessaging.model.ChannelModeratedByAppInstanceUserSummary
          .wrap(item)
      )
      .provideEnvironment(r)
    def listChannelsModeratedByAppInstanceUserPaginated(
        request: zio.aws.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserResponse.ReadOnly
    ] = asyncRequestResponse[
      ListChannelsModeratedByAppInstanceUserRequest,
      ListChannelsModeratedByAppInstanceUserResponse
    ](
      "listChannelsModeratedByAppInstanceUser",
      api.listChannelsModeratedByAppInstanceUser
    )(request.buildAwsValue())
      .map(
        zio.aws.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserResponse.wrap
      )
      .provideEnvironment(r)
    def updateChannelMessage(
        request: zio.aws.chimesdkmessaging.model.UpdateChannelMessageRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.UpdateChannelMessageResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateChannelMessageRequest,
      UpdateChannelMessageResponse
    ]("updateChannelMessage", api.updateChannelMessage)(request.buildAwsValue())
      .map(zio.aws.chimesdkmessaging.model.UpdateChannelMessageResponse.wrap)
      .provideEnvironment(r)
    def getMessagingSessionEndpoint(
        request: zio.aws.chimesdkmessaging.model.GetMessagingSessionEndpointRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.GetMessagingSessionEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      GetMessagingSessionEndpointRequest,
      GetMessagingSessionEndpointResponse
    ]("getMessagingSessionEndpoint", api.getMessagingSessionEndpoint)(
      request.buildAwsValue()
    ).map(
      zio.aws.chimesdkmessaging.model.GetMessagingSessionEndpointResponse.wrap
    ).provideEnvironment(r)
    def updateChannel(
        request: zio.aws.chimesdkmessaging.model.UpdateChannelRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.UpdateChannelResponse.ReadOnly
    ] = asyncRequestResponse[UpdateChannelRequest, UpdateChannelResponse](
      "updateChannel",
      api.updateChannel
    )(request.buildAwsValue())
      .map(zio.aws.chimesdkmessaging.model.UpdateChannelResponse.wrap)
      .provideEnvironment(r)
    def describeChannelFlow(
        request: zio.aws.chimesdkmessaging.model.DescribeChannelFlowRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmessaging.model.DescribeChannelFlowResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeChannelFlowRequest,
      DescribeChannelFlowResponse
    ]("describeChannelFlow", api.describeChannelFlow)(request.buildAwsValue())
      .map(zio.aws.chimesdkmessaging.model.DescribeChannelFlowResponse.wrap)
      .provideEnvironment(r)
  }
  def describeChannelMembership(
      request: zio.aws.chimesdkmessaging.model.DescribeChannelMembershipRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.DescribeChannelMembershipResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeChannelMembership(request))
  def listChannels(
      request: zio.aws.chimesdkmessaging.model.ListChannelsRequest
  ): ZStream[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.ChannelSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listChannels(request))
  def listChannelsPaginated(
      request: zio.aws.chimesdkmessaging.model.ListChannelsRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.ListChannelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listChannelsPaginated(request))
  def channelFlowCallback(
      request: zio.aws.chimesdkmessaging.model.ChannelFlowCallbackRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.ChannelFlowCallbackResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.channelFlowCallback(request))
  def listChannelsAssociatedWithChannelFlow(
      request: zio.aws.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowRequest
  ): ZStream[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.ChannelAssociatedWithFlowSummary.ReadOnly
  ] =
    ZStream.serviceWithStream(_.listChannelsAssociatedWithChannelFlow(request))
  def listChannelsAssociatedWithChannelFlowPaginated(
      request: zio.aws.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.listChannelsAssociatedWithChannelFlowPaginated(request)
  )
  def deleteChannelModerator(
      request: zio.aws.chimesdkmessaging.model.DeleteChannelModeratorRequest
  ): ZIO[zio.aws.chimesdkmessaging.ChimeSdkMessaging, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteChannelModerator(request))
  def describeChannelModeratedByAppInstanceUser(
      request: zio.aws.chimesdkmessaging.model.DescribeChannelModeratedByAppInstanceUserRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.DescribeChannelModeratedByAppInstanceUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeChannelModeratedByAppInstanceUser(request))
  def listChannelMembershipsForAppInstanceUser(
      request: zio.aws.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserRequest
  ): ZStream[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.ChannelMembershipForAppInstanceUserSummary.ReadOnly
  ] = ZStream.serviceWithStream(
    _.listChannelMembershipsForAppInstanceUser(request)
  )
  def listChannelMembershipsForAppInstanceUserPaginated(
      request: zio.aws.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.listChannelMembershipsForAppInstanceUserPaginated(request)
  )
  def sendChannelMessage(
      request: zio.aws.chimesdkmessaging.model.SendChannelMessageRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.SendChannelMessageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendChannelMessage(request))
  def deleteChannelMembership(
      request: zio.aws.chimesdkmessaging.model.DeleteChannelMembershipRequest
  ): ZIO[zio.aws.chimesdkmessaging.ChimeSdkMessaging, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteChannelMembership(request))
  def putChannelMembershipPreferences(
      request: zio.aws.chimesdkmessaging.model.PutChannelMembershipPreferencesRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.PutChannelMembershipPreferencesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putChannelMembershipPreferences(request))
  def listChannelFlows(
      request: zio.aws.chimesdkmessaging.model.ListChannelFlowsRequest
  ): ZStream[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.ChannelFlowSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listChannelFlows(request))
  def listChannelFlowsPaginated(
      request: zio.aws.chimesdkmessaging.model.ListChannelFlowsRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.ListChannelFlowsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listChannelFlowsPaginated(request))
  def deleteChannel(
      request: zio.aws.chimesdkmessaging.model.DeleteChannelRequest
  ): ZIO[zio.aws.chimesdkmessaging.ChimeSdkMessaging, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteChannel(request))
  def listChannelBans(
      request: zio.aws.chimesdkmessaging.model.ListChannelBansRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.chimesdkmessaging.model.ListChannelBansResponse.ReadOnly,
      zio.aws.chimesdkmessaging.model.ChannelBanSummary.ReadOnly
    ]
  ] = ZIO.serviceWithZIO(_.listChannelBans(request))
  def listChannelBansPaginated(
      request: zio.aws.chimesdkmessaging.model.ListChannelBansRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.ListChannelBansResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listChannelBansPaginated(request))
  def listChannelMessages(
      request: zio.aws.chimesdkmessaging.model.ListChannelMessagesRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.chimesdkmessaging.model.ListChannelMessagesResponse.ReadOnly,
      zio.aws.chimesdkmessaging.model.ChannelMessageSummary.ReadOnly
    ]
  ] = ZIO.serviceWithZIO(_.listChannelMessages(request))
  def listChannelMessagesPaginated(
      request: zio.aws.chimesdkmessaging.model.ListChannelMessagesRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.ListChannelMessagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listChannelMessagesPaginated(request))
  def associateChannelFlow(
      request: zio.aws.chimesdkmessaging.model.AssociateChannelFlowRequest
  ): ZIO[zio.aws.chimesdkmessaging.ChimeSdkMessaging, AwsError, Unit] =
    ZIO.serviceWithZIO(_.associateChannelFlow(request))
  def deleteChannelFlow(
      request: zio.aws.chimesdkmessaging.model.DeleteChannelFlowRequest
  ): ZIO[zio.aws.chimesdkmessaging.ChimeSdkMessaging, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteChannelFlow(request))
  def createChannelMembership(
      request: zio.aws.chimesdkmessaging.model.CreateChannelMembershipRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.CreateChannelMembershipResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createChannelMembership(request))
  def createChannel(
      request: zio.aws.chimesdkmessaging.model.CreateChannelRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.CreateChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createChannel(request))
  def describeChannelBan(
      request: zio.aws.chimesdkmessaging.model.DescribeChannelBanRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.DescribeChannelBanResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeChannelBan(request))
  def listChannelMemberships(
      request: zio.aws.chimesdkmessaging.model.ListChannelMembershipsRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.chimesdkmessaging.model.ListChannelMembershipsResponse.ReadOnly,
      zio.aws.chimesdkmessaging.model.ChannelMembershipSummary.ReadOnly
    ]
  ] = ZIO.serviceWithZIO(_.listChannelMemberships(request))
  def listChannelMembershipsPaginated(
      request: zio.aws.chimesdkmessaging.model.ListChannelMembershipsRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.ListChannelMembershipsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listChannelMembershipsPaginated(request))
  def batchCreateChannelMembership(
      request: zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchCreateChannelMembership(request))
  def updateChannelFlow(
      request: zio.aws.chimesdkmessaging.model.UpdateChannelFlowRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.UpdateChannelFlowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateChannelFlow(request))
  def updateChannelReadMarker(
      request: zio.aws.chimesdkmessaging.model.UpdateChannelReadMarkerRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.UpdateChannelReadMarkerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateChannelReadMarker(request))
  def createChannelModerator(
      request: zio.aws.chimesdkmessaging.model.CreateChannelModeratorRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.CreateChannelModeratorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createChannelModerator(request))
  def untagResource(
      request: zio.aws.chimesdkmessaging.model.UntagResourceRequest
  ): ZIO[zio.aws.chimesdkmessaging.ChimeSdkMessaging, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def getChannelMessage(
      request: zio.aws.chimesdkmessaging.model.GetChannelMessageRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.GetChannelMessageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getChannelMessage(request))
  def createChannelBan(
      request: zio.aws.chimesdkmessaging.model.CreateChannelBanRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.CreateChannelBanResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createChannelBan(request))
  def deleteChannelMessage(
      request: zio.aws.chimesdkmessaging.model.DeleteChannelMessageRequest
  ): ZIO[zio.aws.chimesdkmessaging.ChimeSdkMessaging, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteChannelMessage(request))
  def redactChannelMessage(
      request: zio.aws.chimesdkmessaging.model.RedactChannelMessageRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.RedactChannelMessageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.redactChannelMessage(request))
  def deleteChannelBan(
      request: zio.aws.chimesdkmessaging.model.DeleteChannelBanRequest
  ): ZIO[zio.aws.chimesdkmessaging.ChimeSdkMessaging, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteChannelBan(request))
  def describeChannelModerator(
      request: zio.aws.chimesdkmessaging.model.DescribeChannelModeratorRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.DescribeChannelModeratorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeChannelModerator(request))
  def describeChannelMembershipForAppInstanceUser(
      request: zio.aws.chimesdkmessaging.model.DescribeChannelMembershipForAppInstanceUserRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.DescribeChannelMembershipForAppInstanceUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeChannelMembershipForAppInstanceUser(request))
  def listTagsForResource(
      request: zio.aws.chimesdkmessaging.model.ListTagsForResourceRequest
  ): ZIO[zio.aws.chimesdkmessaging.ChimeSdkMessaging, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listTagsForResource(request))
  def disassociateChannelFlow(
      request: zio.aws.chimesdkmessaging.model.DisassociateChannelFlowRequest
  ): ZIO[zio.aws.chimesdkmessaging.ChimeSdkMessaging, AwsError, Unit] =
    ZIO.serviceWithZIO(_.disassociateChannelFlow(request))
  def getChannelMembershipPreferences(
      request: zio.aws.chimesdkmessaging.model.GetChannelMembershipPreferencesRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.GetChannelMembershipPreferencesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getChannelMembershipPreferences(request))
  def tagResource(
      request: zio.aws.chimesdkmessaging.model.TagResourceRequest
  ): ZIO[zio.aws.chimesdkmessaging.ChimeSdkMessaging, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def describeChannel(
      request: zio.aws.chimesdkmessaging.model.DescribeChannelRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.DescribeChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeChannel(request))
  def createChannelFlow(
      request: zio.aws.chimesdkmessaging.model.CreateChannelFlowRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.CreateChannelFlowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createChannelFlow(request))
  def listChannelModerators(
      request: zio.aws.chimesdkmessaging.model.ListChannelModeratorsRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.chimesdkmessaging.model.ListChannelModeratorsResponse.ReadOnly,
      zio.aws.chimesdkmessaging.model.ChannelModeratorSummary.ReadOnly
    ]
  ] = ZIO.serviceWithZIO(_.listChannelModerators(request))
  def listChannelModeratorsPaginated(
      request: zio.aws.chimesdkmessaging.model.ListChannelModeratorsRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.ListChannelModeratorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listChannelModeratorsPaginated(request))
  def getChannelMessageStatus(
      request: zio.aws.chimesdkmessaging.model.GetChannelMessageStatusRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.GetChannelMessageStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getChannelMessageStatus(request))
  def listChannelsModeratedByAppInstanceUser(
      request: zio.aws.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserRequest
  ): ZStream[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.ChannelModeratedByAppInstanceUserSummary.ReadOnly
  ] =
    ZStream.serviceWithStream(_.listChannelsModeratedByAppInstanceUser(request))
  def listChannelsModeratedByAppInstanceUserPaginated(
      request: zio.aws.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.listChannelsModeratedByAppInstanceUserPaginated(request)
  )
  def updateChannelMessage(
      request: zio.aws.chimesdkmessaging.model.UpdateChannelMessageRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.UpdateChannelMessageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateChannelMessage(request))
  def getMessagingSessionEndpoint(
      request: zio.aws.chimesdkmessaging.model.GetMessagingSessionEndpointRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.GetMessagingSessionEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMessagingSessionEndpoint(request))
  def updateChannel(
      request: zio.aws.chimesdkmessaging.model.UpdateChannelRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.UpdateChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateChannel(request))
  def describeChannelFlow(
      request: zio.aws.chimesdkmessaging.model.DescribeChannelFlowRequest
  ): ZIO[
    zio.aws.chimesdkmessaging.ChimeSdkMessaging,
    AwsError,
    zio.aws.chimesdkmessaging.model.DescribeChannelFlowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeChannelFlow(request))
}
