package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeChannelMembershipResponse(
    channelMembership: Optional[
      zio.aws.chimesdkmessaging.model.ChannelMembership
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelMembershipResponse = {
    import DescribeChannelMembershipResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelMembershipResponse
      .builder()
      .optionallyWith(channelMembership.map(value => value.buildAwsValue()))(
        _.channelMembership
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.DescribeChannelMembershipResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.DescribeChannelMembershipResponse
      .wrap(buildAwsValue())
}
object DescribeChannelMembershipResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelMembershipResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.DescribeChannelMembershipResponse =
      zio.aws.chimesdkmessaging.model.DescribeChannelMembershipResponse(
        channelMembership.map(value => value.asEditable)
      )
    def channelMembership
        : Optional[zio.aws.chimesdkmessaging.model.ChannelMembership.ReadOnly]
    def getChannelMembership: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelMembership.ReadOnly
    ] = AwsError.unwrapOptionField("channelMembership", channelMembership)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelMembershipResponse
  ) extends zio.aws.chimesdkmessaging.model.DescribeChannelMembershipResponse.ReadOnly {
    override val channelMembership
        : Optional[zio.aws.chimesdkmessaging.model.ChannelMembership.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channelMembership())
        .map(value =>
          zio.aws.chimesdkmessaging.model.ChannelMembership.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelMembershipResponse
  ): zio.aws.chimesdkmessaging.model.DescribeChannelMembershipResponse.ReadOnly =
    new Wrapper(impl)
}
