package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.{MessageId, ChimeArn}
import scala.jdk.CollectionConverters._
final case class SendChannelMessageResponse(
    channelArn: Optional[ChimeArn] = Optional.Absent,
    messageId: Optional[MessageId] = Optional.Absent,
    status: Optional[
      zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.SendChannelMessageResponse = {
    import SendChannelMessageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.SendChannelMessageResponse
      .builder()
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(
        messageId.map(value => MessageId.unwrap(value): java.lang.String)
      )(_.messageId)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.SendChannelMessageResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.SendChannelMessageResponse
      .wrap(buildAwsValue())
}
object SendChannelMessageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.SendChannelMessageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.SendChannelMessageResponse =
      zio.aws.chimesdkmessaging.model.SendChannelMessageResponse(
        channelArn.map(value => value),
        messageId.map(value => value),
        status.map(value => value.asEditable)
      )
    def channelArn: Optional[ChimeArn]
    def messageId: Optional[MessageId]
    def status: Optional[
      zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure.ReadOnly
    ]
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getMessageId: ZIO[Any, AwsError, MessageId] =
      AwsError.unwrapOptionField("messageId", messageId)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.SendChannelMessageResponse
  ) extends zio.aws.chimesdkmessaging.model.SendChannelMessageResponse.ReadOnly {
    override val channelArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val messageId: Optional[MessageId] = zio.aws.core.internal
      .optionalFromNullable(impl.messageId())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.MessageId(value))
    override val status: Optional[
      zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.SendChannelMessageResponse
  ): zio.aws.chimesdkmessaging.model.SendChannelMessageResponse.ReadOnly =
    new Wrapper(impl)
}
