package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmessaging.model.primitives.ChimeArn
import scala.jdk.CollectionConverters._
final case class GetChannelMembershipPreferencesRequest(
    channelArn: ChimeArn,
    memberArn: ChimeArn,
    chimeBearer: ChimeArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.GetChannelMembershipPreferencesRequest = {
    import GetChannelMembershipPreferencesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.GetChannelMembershipPreferencesRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .memberArn(ChimeArn.unwrap(memberArn): java.lang.String)
      .chimeBearer(ChimeArn.unwrap(chimeBearer): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.GetChannelMembershipPreferencesRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.GetChannelMembershipPreferencesRequest
      .wrap(buildAwsValue())
}
object GetChannelMembershipPreferencesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.GetChannelMembershipPreferencesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.GetChannelMembershipPreferencesRequest =
      zio.aws.chimesdkmessaging.model.GetChannelMembershipPreferencesRequest(
        channelArn,
        memberArn,
        chimeBearer
      )
    def channelArn: ChimeArn
    def memberArn: ChimeArn
    def chimeBearer: ChimeArn
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getMemberArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(memberArn)
    def getChimeBearer: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.GetChannelMembershipPreferencesRequest
  ) extends zio.aws.chimesdkmessaging.model.GetChannelMembershipPreferencesRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.channelArn())
    override val memberArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.memberArn())
    override val chimeBearer: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.chimeBearer())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.GetChannelMembershipPreferencesRequest
  ): zio.aws.chimesdkmessaging.model.GetChannelMembershipPreferencesRequest.ReadOnly =
    new Wrapper(impl)
}
