package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.{
  MessageAttributeName,
  Metadata,
  NonEmptyContent,
  MessageId
}
import scala.jdk.CollectionConverters._
final case class ChannelMessageCallback(
    messageId: MessageId,
    content: Optional[NonEmptyContent] = Optional.Absent,
    metadata: Optional[Metadata] = Optional.Absent,
    pushNotification: Optional[
      zio.aws.chimesdkmessaging.model.PushNotificationConfiguration
    ] = Optional.Absent,
    messageAttributes: Optional[Map[
      MessageAttributeName,
      zio.aws.chimesdkmessaging.model.MessageAttributeValue
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageCallback = {
    import ChannelMessageCallback.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageCallback
      .builder()
      .messageId(MessageId.unwrap(messageId): java.lang.String)
      .optionallyWith(
        content.map(value => NonEmptyContent.unwrap(value): java.lang.String)
      )(_.content)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .optionallyWith(pushNotification.map(value => value.buildAwsValue()))(
        _.pushNotification
      )
      .optionallyWith(
        messageAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (MessageAttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.messageAttributes)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ChannelMessageCallback.ReadOnly =
    zio.aws.chimesdkmessaging.model.ChannelMessageCallback.wrap(buildAwsValue())
}
object ChannelMessageCallback {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageCallback
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.ChannelMessageCallback =
      zio.aws.chimesdkmessaging.model.ChannelMessageCallback(
        messageId,
        content.map(value => value),
        metadata.map(value => value),
        pushNotification.map(value => value.asEditable),
        messageAttributes.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def messageId: MessageId
    def content: Optional[NonEmptyContent]
    def metadata: Optional[Metadata]
    def pushNotification: Optional[
      zio.aws.chimesdkmessaging.model.PushNotificationConfiguration.ReadOnly
    ]
    def messageAttributes: Optional[Map[
      MessageAttributeName,
      zio.aws.chimesdkmessaging.model.MessageAttributeValue.ReadOnly
    ]]
    def getMessageId: ZIO[Any, Nothing, MessageId] = ZIO.succeed(messageId)
    def getContent: ZIO[Any, AwsError, NonEmptyContent] =
      AwsError.unwrapOptionField("content", content)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getPushNotification: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.PushNotificationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("pushNotification", pushNotification)
    def getMessageAttributes: ZIO[Any, AwsError, Map[
      MessageAttributeName,
      zio.aws.chimesdkmessaging.model.MessageAttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("messageAttributes", messageAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageCallback
  ) extends zio.aws.chimesdkmessaging.model.ChannelMessageCallback.ReadOnly {
    override val messageId: MessageId =
      zio.aws.chimesdkmessaging.model.primitives.MessageId(impl.messageId())
    override val content: Optional[NonEmptyContent] = zio.aws.core.internal
      .optionalFromNullable(impl.content())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.NonEmptyContent(value)
      )
    override val metadata: Optional[Metadata] = zio.aws.core.internal
      .optionalFromNullable(impl.metadata())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Metadata(value))
    override val pushNotification: Optional[
      zio.aws.chimesdkmessaging.model.PushNotificationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.pushNotification())
      .map(value =>
        zio.aws.chimesdkmessaging.model.PushNotificationConfiguration
          .wrap(value)
      )
    override val messageAttributes: Optional[Map[
      MessageAttributeName,
      zio.aws.chimesdkmessaging.model.MessageAttributeValue.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.messageAttributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.chimesdkmessaging.model.primitives.MessageAttributeName(
              key
            ) -> zio.aws.chimesdkmessaging.model.MessageAttributeValue
              .wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageCallback
  ): zio.aws.chimesdkmessaging.model.ChannelMessageCallback.ReadOnly =
    new Wrapper(impl)
}
