package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.{CallbackIdType, ChimeArn}
import scala.jdk.CollectionConverters._
final case class ChannelFlowCallbackResponse(
    channelArn: Optional[ChimeArn] = Optional.Absent,
    callbackId: Optional[CallbackIdType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlowCallbackResponse = {
    import ChannelFlowCallbackResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlowCallbackResponse
      .builder()
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(
        callbackId.map(value => CallbackIdType.unwrap(value): java.lang.String)
      )(_.callbackId)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ChannelFlowCallbackResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.ChannelFlowCallbackResponse
      .wrap(buildAwsValue())
}
object ChannelFlowCallbackResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlowCallbackResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.ChannelFlowCallbackResponse =
      zio.aws.chimesdkmessaging.model.ChannelFlowCallbackResponse(
        channelArn.map(value => value),
        callbackId.map(value => value)
      )
    def channelArn: Optional[ChimeArn]
    def callbackId: Optional[CallbackIdType]
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getCallbackId: ZIO[Any, AwsError, CallbackIdType] =
      AwsError.unwrapOptionField("callbackId", callbackId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlowCallbackResponse
  ) extends zio.aws.chimesdkmessaging.model.ChannelFlowCallbackResponse.ReadOnly {
    override val channelArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val callbackId: Optional[CallbackIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.callbackId())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.CallbackIdType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlowCallbackResponse
  ): zio.aws.chimesdkmessaging.model.ChannelFlowCallbackResponse.ReadOnly =
    new Wrapper(impl)
}
