package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmessaging.model.primitives.ChimeArn
import scala.jdk.CollectionConverters._
final case class DescribeChannelModeratorRequest(
    channelArn: ChimeArn,
    channelModeratorArn: ChimeArn,
    chimeBearer: ChimeArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelModeratorRequest = {
    import DescribeChannelModeratorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelModeratorRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .channelModeratorArn(
        ChimeArn.unwrap(channelModeratorArn): java.lang.String
      )
      .chimeBearer(ChimeArn.unwrap(chimeBearer): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.DescribeChannelModeratorRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.DescribeChannelModeratorRequest
      .wrap(buildAwsValue())
}
object DescribeChannelModeratorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelModeratorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.DescribeChannelModeratorRequest =
      zio.aws.chimesdkmessaging.model.DescribeChannelModeratorRequest(
        channelArn,
        channelModeratorArn,
        chimeBearer
      )
    def channelArn: ChimeArn
    def channelModeratorArn: ChimeArn
    def chimeBearer: ChimeArn
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getChannelModeratorArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(channelModeratorArn)
    def getChimeBearer: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelModeratorRequest
  ) extends zio.aws.chimesdkmessaging.model.DescribeChannelModeratorRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.channelArn())
    override val channelModeratorArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives
        .ChimeArn(impl.channelModeratorArn())
    override val chimeBearer: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.chimeBearer())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelModeratorRequest
  ): zio.aws.chimesdkmessaging.model.DescribeChannelModeratorRequest.ReadOnly =
    new Wrapper(impl)
}
