package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.ChimeArn
import scala.jdk.CollectionConverters._
final case class CreateChannelMembershipResponse(
    channelArn: Optional[ChimeArn] = Optional.Absent,
    member: Optional[zio.aws.chimesdkmessaging.model.Identity] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelMembershipResponse = {
    import CreateChannelMembershipResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelMembershipResponse
      .builder()
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(member.map(value => value.buildAwsValue()))(_.member)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.CreateChannelMembershipResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.CreateChannelMembershipResponse
      .wrap(buildAwsValue())
}
object CreateChannelMembershipResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelMembershipResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.CreateChannelMembershipResponse =
      zio.aws.chimesdkmessaging.model.CreateChannelMembershipResponse(
        channelArn.map(value => value),
        member.map(value => value.asEditable)
      )
    def channelArn: Optional[ChimeArn]
    def member: Optional[zio.aws.chimesdkmessaging.model.Identity.ReadOnly]
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getMember: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.Identity.ReadOnly
    ] = AwsError.unwrapOptionField("member", member)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelMembershipResponse
  ) extends zio.aws.chimesdkmessaging.model.CreateChannelMembershipResponse.ReadOnly {
    override val channelArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val member
        : Optional[zio.aws.chimesdkmessaging.model.Identity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.member())
        .map(value => zio.aws.chimesdkmessaging.model.Identity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelMembershipResponse
  ): zio.aws.chimesdkmessaging.model.CreateChannelMembershipResponse.ReadOnly =
    new Wrapper(impl)
}
