package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.{
  Metadata,
  NonEmptyResourceName,
  ChimeArn
}
import scala.jdk.CollectionConverters._
final case class UpdateChannelRequest(
    channelArn: ChimeArn,
    name: NonEmptyResourceName,
    mode: zio.aws.chimesdkmessaging.model.ChannelMode,
    metadata: Optional[Metadata] = Optional.Absent,
    chimeBearer: ChimeArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelRequest = {
    import UpdateChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .name(NonEmptyResourceName.unwrap(name): java.lang.String)
      .mode(mode.unwrap)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .chimeBearer(ChimeArn.unwrap(chimeBearer): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.UpdateChannelRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.UpdateChannelRequest.wrap(buildAwsValue())
}
object UpdateChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.UpdateChannelRequest =
      zio.aws.chimesdkmessaging.model.UpdateChannelRequest(
        channelArn,
        name,
        mode,
        metadata.map(value => value),
        chimeBearer
      )
    def channelArn: ChimeArn
    def name: NonEmptyResourceName
    def mode: zio.aws.chimesdkmessaging.model.ChannelMode
    def metadata: Optional[Metadata]
    def chimeBearer: ChimeArn
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getName: ZIO[Any, Nothing, NonEmptyResourceName] = ZIO.succeed(name)
    def getMode
        : ZIO[Any, Nothing, zio.aws.chimesdkmessaging.model.ChannelMode] =
      ZIO.succeed(mode)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getChimeBearer: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelRequest
  ) extends zio.aws.chimesdkmessaging.model.UpdateChannelRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.channelArn())
    override val name: NonEmptyResourceName =
      zio.aws.chimesdkmessaging.model.primitives
        .NonEmptyResourceName(impl.name())
    override val mode: zio.aws.chimesdkmessaging.model.ChannelMode =
      zio.aws.chimesdkmessaging.model.ChannelMode.wrap(impl.mode())
    override val metadata: Optional[Metadata] = zio.aws.core.internal
      .optionalFromNullable(impl.metadata())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Metadata(value))
    override val chimeBearer: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.chimeBearer())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelRequest
  ): zio.aws.chimesdkmessaging.model.UpdateChannelRequest.ReadOnly =
    new Wrapper(impl)
}
