package zio.aws.chimesdkmessaging.model
import zio.aws.chimesdkmessaging.model.primitives.{
  Timestamp,
  Metadata,
  ChimeArn,
  NonEmptyResourceName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Channel(
    name: Optional[NonEmptyResourceName] = Optional.Absent,
    channelArn: Optional[ChimeArn] = Optional.Absent,
    mode: Optional[zio.aws.chimesdkmessaging.model.ChannelMode] =
      Optional.Absent,
    privacy: Optional[zio.aws.chimesdkmessaging.model.ChannelPrivacy] =
      Optional.Absent,
    metadata: Optional[Metadata] = Optional.Absent,
    createdBy: Optional[zio.aws.chimesdkmessaging.model.Identity] =
      Optional.Absent,
    createdTimestamp: Optional[Timestamp] = Optional.Absent,
    lastMessageTimestamp: Optional[Timestamp] = Optional.Absent,
    lastUpdatedTimestamp: Optional[Timestamp] = Optional.Absent,
    channelFlowArn: Optional[ChimeArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.Channel = {
    import Channel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.Channel
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(privacy.map(value => value.unwrap))(_.privacy)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        lastMessageTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastMessageTimestamp)
      .optionallyWith(
        lastUpdatedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTimestamp)
      .optionallyWith(
        channelFlowArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelFlowArn)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmessaging.model.Channel.ReadOnly =
    zio.aws.chimesdkmessaging.model.Channel.wrap(buildAwsValue())
}
object Channel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.Channel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.Channel =
      zio.aws.chimesdkmessaging.model.Channel(
        name.map(value => value),
        channelArn.map(value => value),
        mode.map(value => value),
        privacy.map(value => value),
        metadata.map(value => value),
        createdBy.map(value => value.asEditable),
        createdTimestamp.map(value => value),
        lastMessageTimestamp.map(value => value),
        lastUpdatedTimestamp.map(value => value),
        channelFlowArn.map(value => value)
      )
    def name: Optional[NonEmptyResourceName]
    def channelArn: Optional[ChimeArn]
    def mode: Optional[zio.aws.chimesdkmessaging.model.ChannelMode]
    def privacy: Optional[zio.aws.chimesdkmessaging.model.ChannelPrivacy]
    def metadata: Optional[Metadata]
    def createdBy: Optional[zio.aws.chimesdkmessaging.model.Identity.ReadOnly]
    def createdTimestamp: Optional[Timestamp]
    def lastMessageTimestamp: Optional[Timestamp]
    def lastUpdatedTimestamp: Optional[Timestamp]
    def channelFlowArn: Optional[ChimeArn]
    def getName: ZIO[Any, AwsError, NonEmptyResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getMode
        : ZIO[Any, AwsError, zio.aws.chimesdkmessaging.model.ChannelMode] =
      AwsError.unwrapOptionField("mode", mode)
    def getPrivacy
        : ZIO[Any, AwsError, zio.aws.chimesdkmessaging.model.ChannelPrivacy] =
      AwsError.unwrapOptionField("privacy", privacy)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getCreatedBy: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.Identity.ReadOnly
    ] = AwsError.unwrapOptionField("createdBy", createdBy)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getLastMessageTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastMessageTimestamp", lastMessageTimestamp)
    def getLastUpdatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestamp)
    def getChannelFlowArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelFlowArn", channelFlowArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.Channel
  ) extends zio.aws.chimesdkmessaging.model.Channel.ReadOnly {
    override val name: Optional[NonEmptyResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.NonEmptyResourceName(value)
      )
    override val channelArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val mode: Optional[zio.aws.chimesdkmessaging.model.ChannelMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mode())
        .map(value => zio.aws.chimesdkmessaging.model.ChannelMode.wrap(value))
    override val privacy
        : Optional[zio.aws.chimesdkmessaging.model.ChannelPrivacy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privacy())
        .map(value =>
          zio.aws.chimesdkmessaging.model.ChannelPrivacy.wrap(value)
        )
    override val metadata: Optional[Metadata] = zio.aws.core.internal
      .optionalFromNullable(impl.metadata())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Metadata(value))
    override val createdBy
        : Optional[zio.aws.chimesdkmessaging.model.Identity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBy())
        .map(value => zio.aws.chimesdkmessaging.model.Identity.wrap(value))
    override val createdTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTimestamp())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Timestamp(value))
    override val lastMessageTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastMessageTimestamp())
        .map(value =>
          zio.aws.chimesdkmessaging.model.primitives.Timestamp(value)
        )
    override val lastUpdatedTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTimestamp())
        .map(value =>
          zio.aws.chimesdkmessaging.model.primitives.Timestamp(value)
        )
    override val channelFlowArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelFlowArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.Channel
  ): zio.aws.chimesdkmessaging.model.Channel.ReadOnly = new Wrapper(impl)
}
