package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeChannelResponse(
    channel: Optional[zio.aws.chimesdkmessaging.model.Channel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelResponse = {
    import DescribeChannelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelResponse
      .builder()
      .optionallyWith(channel.map(value => value.buildAwsValue()))(_.channel)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.DescribeChannelResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.DescribeChannelResponse
      .wrap(buildAwsValue())
}
object DescribeChannelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.DescribeChannelResponse =
      zio.aws.chimesdkmessaging.model
        .DescribeChannelResponse(channel.map(value => value.asEditable))
    def channel: Optional[zio.aws.chimesdkmessaging.model.Channel.ReadOnly]
    def getChannel
        : ZIO[Any, AwsError, zio.aws.chimesdkmessaging.model.Channel.ReadOnly] =
      AwsError.unwrapOptionField("channel", channel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelResponse
  ) extends zio.aws.chimesdkmessaging.model.DescribeChannelResponse.ReadOnly {
    override val channel
        : Optional[zio.aws.chimesdkmessaging.model.Channel.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channel())
        .map(value => zio.aws.chimesdkmessaging.model.Channel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelResponse
  ): zio.aws.chimesdkmessaging.model.DescribeChannelResponse.ReadOnly =
    new Wrapper(impl)
}
