package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmessaging.model.primitives.ChimeArn
import scala.jdk.CollectionConverters._
final case class DescribeChannelFlowRequest(channelFlowArn: ChimeArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelFlowRequest = {
    import DescribeChannelFlowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelFlowRequest
      .builder()
      .channelFlowArn(ChimeArn.unwrap(channelFlowArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.DescribeChannelFlowRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.DescribeChannelFlowRequest
      .wrap(buildAwsValue())
}
object DescribeChannelFlowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelFlowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.DescribeChannelFlowRequest =
      zio.aws.chimesdkmessaging.model.DescribeChannelFlowRequest(channelFlowArn)
    def channelFlowArn: ChimeArn
    def getChannelFlowArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(channelFlowArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelFlowRequest
  ) extends zio.aws.chimesdkmessaging.model.DescribeChannelFlowRequest.ReadOnly {
    override val channelFlowArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.channelFlowArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelFlowRequest
  ): zio.aws.chimesdkmessaging.model.DescribeChannelFlowRequest.ReadOnly =
    new Wrapper(impl)
}
