package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.{
  ClientRequestToken,
  Metadata,
  NonEmptyResourceName,
  ChimeArn
}
import scala.jdk.CollectionConverters._
final case class CreateChannelRequest(
    appInstanceArn: ChimeArn,
    name: NonEmptyResourceName,
    mode: Optional[zio.aws.chimesdkmessaging.model.ChannelMode] =
      Optional.Absent,
    privacy: Optional[zio.aws.chimesdkmessaging.model.ChannelPrivacy] =
      Optional.Absent,
    metadata: Optional[Metadata] = Optional.Absent,
    clientRequestToken: ClientRequestToken,
    tags: Optional[Iterable[zio.aws.chimesdkmessaging.model.Tag]] =
      Optional.Absent,
    chimeBearer: ChimeArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelRequest = {
    import CreateChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelRequest
      .builder()
      .appInstanceArn(ChimeArn.unwrap(appInstanceArn): java.lang.String)
      .name(NonEmptyResourceName.unwrap(name): java.lang.String)
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(privacy.map(value => value.unwrap))(_.privacy)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .clientRequestToken(
        ClientRequestToken.unwrap(clientRequestToken): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .chimeBearer(ChimeArn.unwrap(chimeBearer): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.CreateChannelRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.CreateChannelRequest.wrap(buildAwsValue())
}
object CreateChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.CreateChannelRequest =
      zio.aws.chimesdkmessaging.model.CreateChannelRequest(
        appInstanceArn,
        name,
        mode.map(value => value),
        privacy.map(value => value),
        metadata.map(value => value),
        clientRequestToken,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        chimeBearer
      )
    def appInstanceArn: ChimeArn
    def name: NonEmptyResourceName
    def mode: Optional[zio.aws.chimesdkmessaging.model.ChannelMode]
    def privacy: Optional[zio.aws.chimesdkmessaging.model.ChannelPrivacy]
    def metadata: Optional[Metadata]
    def clientRequestToken: ClientRequestToken
    def tags: Optional[List[zio.aws.chimesdkmessaging.model.Tag.ReadOnly]]
    def chimeBearer: ChimeArn
    def getAppInstanceArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(appInstanceArn)
    def getName: ZIO[Any, Nothing, NonEmptyResourceName] = ZIO.succeed(name)
    def getMode
        : ZIO[Any, AwsError, zio.aws.chimesdkmessaging.model.ChannelMode] =
      AwsError.unwrapOptionField("mode", mode)
    def getPrivacy
        : ZIO[Any, AwsError, zio.aws.chimesdkmessaging.model.ChannelPrivacy] =
      AwsError.unwrapOptionField("privacy", privacy)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getClientRequestToken: ZIO[Any, Nothing, ClientRequestToken] =
      ZIO.succeed(clientRequestToken)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmessaging.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getChimeBearer: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelRequest
  ) extends zio.aws.chimesdkmessaging.model.CreateChannelRequest.ReadOnly {
    override val appInstanceArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.appInstanceArn())
    override val name: NonEmptyResourceName =
      zio.aws.chimesdkmessaging.model.primitives
        .NonEmptyResourceName(impl.name())
    override val mode: Optional[zio.aws.chimesdkmessaging.model.ChannelMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mode())
        .map(value => zio.aws.chimesdkmessaging.model.ChannelMode.wrap(value))
    override val privacy
        : Optional[zio.aws.chimesdkmessaging.model.ChannelPrivacy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privacy())
        .map(value =>
          zio.aws.chimesdkmessaging.model.ChannelPrivacy.wrap(value)
        )
    override val metadata: Optional[Metadata] = zio.aws.core.internal
      .optionalFromNullable(impl.metadata())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Metadata(value))
    override val clientRequestToken: ClientRequestToken =
      zio.aws.chimesdkmessaging.model.primitives
        .ClientRequestToken(impl.clientRequestToken())
    override val tags
        : Optional[List[zio.aws.chimesdkmessaging.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chimesdkmessaging.model.Tag.wrap(item)
          }.toList
        )
    override val chimeBearer: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.chimeBearer())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelRequest
  ): zio.aws.chimesdkmessaging.model.CreateChannelRequest.ReadOnly =
    new Wrapper(impl)
}
