package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmessaging.model.primitives.ChimeArn
import scala.jdk.CollectionConverters._
final case class CreateChannelModeratorRequest(
    channelArn: ChimeArn,
    channelModeratorArn: ChimeArn,
    chimeBearer: ChimeArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelModeratorRequest = {
    import CreateChannelModeratorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelModeratorRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .channelModeratorArn(
        ChimeArn.unwrap(channelModeratorArn): java.lang.String
      )
      .chimeBearer(ChimeArn.unwrap(chimeBearer): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.CreateChannelModeratorRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.CreateChannelModeratorRequest
      .wrap(buildAwsValue())
}
object CreateChannelModeratorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelModeratorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.CreateChannelModeratorRequest =
      zio.aws.chimesdkmessaging.model.CreateChannelModeratorRequest(
        channelArn,
        channelModeratorArn,
        chimeBearer
      )
    def channelArn: ChimeArn
    def channelModeratorArn: ChimeArn
    def chimeBearer: ChimeArn
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getChannelModeratorArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(channelModeratorArn)
    def getChimeBearer: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelModeratorRequest
  ) extends zio.aws.chimesdkmessaging.model.CreateChannelModeratorRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.channelArn())
    override val channelModeratorArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives
        .ChimeArn(impl.channelModeratorArn())
    override val chimeBearer: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.chimeBearer())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelModeratorRequest
  ): zio.aws.chimesdkmessaging.model.CreateChannelModeratorRequest.ReadOnly =
    new Wrapper(impl)
}
