package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListChannelFlowsResponse(
    channelFlows: Optional[
      Iterable[zio.aws.chimesdkmessaging.model.ChannelFlowSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelFlowsResponse = {
    import ListChannelFlowsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelFlowsResponse
      .builder()
      .optionallyWith(
        channelFlows.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.channelFlows)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ListChannelFlowsResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.ListChannelFlowsResponse
      .wrap(buildAwsValue())
}
object ListChannelFlowsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelFlowsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.ListChannelFlowsResponse =
      zio.aws.chimesdkmessaging.model.ListChannelFlowsResponse(
        channelFlows.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def channelFlows: Optional[
      List[zio.aws.chimesdkmessaging.model.ChannelFlowSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getChannelFlows: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmessaging.model.ChannelFlowSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("channelFlows", channelFlows)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelFlowsResponse
  ) extends zio.aws.chimesdkmessaging.model.ListChannelFlowsResponse.ReadOnly {
    override val channelFlows: Optional[
      List[zio.aws.chimesdkmessaging.model.ChannelFlowSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.channelFlows())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkmessaging.model.ChannelFlowSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelFlowsResponse
  ): zio.aws.chimesdkmessaging.model.ListChannelFlowsResponse.ReadOnly =
    new Wrapper(impl)
}
