package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmessaging.model.primitives.ChimeArn
import scala.jdk.CollectionConverters._
final case class DisassociateChannelFlowRequest(
    channelArn: ChimeArn,
    channelFlowArn: ChimeArn,
    chimeBearer: ChimeArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.DisassociateChannelFlowRequest = {
    import DisassociateChannelFlowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.DisassociateChannelFlowRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .channelFlowArn(ChimeArn.unwrap(channelFlowArn): java.lang.String)
      .chimeBearer(ChimeArn.unwrap(chimeBearer): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.DisassociateChannelFlowRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.DisassociateChannelFlowRequest
      .wrap(buildAwsValue())
}
object DisassociateChannelFlowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.DisassociateChannelFlowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.DisassociateChannelFlowRequest =
      zio.aws.chimesdkmessaging.model
        .DisassociateChannelFlowRequest(channelArn, channelFlowArn, chimeBearer)
    def channelArn: ChimeArn
    def channelFlowArn: ChimeArn
    def chimeBearer: ChimeArn
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getChannelFlowArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(channelFlowArn)
    def getChimeBearer: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.DisassociateChannelFlowRequest
  ) extends zio.aws.chimesdkmessaging.model.DisassociateChannelFlowRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.channelArn())
    override val channelFlowArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.channelFlowArn())
    override val chimeBearer: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.chimeBearer())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.DisassociateChannelFlowRequest
  ): zio.aws.chimesdkmessaging.model.DisassociateChannelFlowRequest.ReadOnly =
    new Wrapper(impl)
}
