package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchCreateChannelMembershipResponse(
    batchChannelMemberships: Optional[
      zio.aws.chimesdkmessaging.model.BatchChannelMemberships
    ] = Optional.Absent,
    errors: Optional[Iterable[
      zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipError
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.BatchCreateChannelMembershipResponse = {
    import BatchCreateChannelMembershipResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.BatchCreateChannelMembershipResponse
      .builder()
      .optionallyWith(
        batchChannelMemberships.map(value => value.buildAwsValue())
      )(_.batchChannelMemberships)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipResponse
      .wrap(buildAwsValue())
}
object BatchCreateChannelMembershipResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.BatchCreateChannelMembershipResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipResponse =
      zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipResponse(
        batchChannelMemberships.map(value => value.asEditable),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def batchChannelMemberships: Optional[
      zio.aws.chimesdkmessaging.model.BatchChannelMemberships.ReadOnly
    ]
    def errors: Optional[List[
      zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipError.ReadOnly
    ]]
    def getBatchChannelMemberships: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.BatchChannelMemberships.ReadOnly
    ] = AwsError.unwrapOptionField(
      "batchChannelMemberships",
      batchChannelMemberships
    )
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.BatchCreateChannelMembershipResponse
  ) extends zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipResponse.ReadOnly {
    override val batchChannelMemberships: Optional[
      zio.aws.chimesdkmessaging.model.BatchChannelMemberships.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.batchChannelMemberships())
      .map(value =>
        zio.aws.chimesdkmessaging.model.BatchChannelMemberships.wrap(value)
      )
    override val errors: Optional[List[
      zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipError.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipError
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.BatchCreateChannelMembershipResponse
  ): zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipResponse.ReadOnly =
    new Wrapper(impl)
}
