package zio.aws.chimesdkmessaging.model
import zio.aws.chimesdkmessaging.model.primitives.{
  NextToken,
  MaxResults,
  ChimeArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListChannelBansRequest(
    channelArn: ChimeArn,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    chimeBearer: ChimeArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelBansRequest = {
    import ListChannelBansRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelBansRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .chimeBearer(ChimeArn.unwrap(chimeBearer): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ListChannelBansRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.ListChannelBansRequest.wrap(buildAwsValue())
}
object ListChannelBansRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelBansRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.ListChannelBansRequest =
      zio.aws.chimesdkmessaging.model.ListChannelBansRequest(
        channelArn,
        maxResults.map(value => value),
        nextToken.map(value => value),
        chimeBearer
      )
    def channelArn: ChimeArn
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def chimeBearer: ChimeArn
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getChimeBearer: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelBansRequest
  ) extends zio.aws.chimesdkmessaging.model.ListChannelBansRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.channelArn())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.MaxResults(value)
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.NextToken(value))
    override val chimeBearer: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.chimeBearer())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelBansRequest
  ): zio.aws.chimesdkmessaging.model.ListChannelBansRequest.ReadOnly =
    new Wrapper(impl)
}
