package zio.aws.chimesdkmessaging.model
import zio.aws.chimesdkmessaging.model.primitives.{Timestamp, ChimeArn}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ChannelMembership(
    invitedBy: Optional[zio.aws.chimesdkmessaging.model.Identity] =
      Optional.Absent,
    `type`: Optional[zio.aws.chimesdkmessaging.model.ChannelMembershipType] =
      Optional.Absent,
    member: Optional[zio.aws.chimesdkmessaging.model.Identity] =
      Optional.Absent,
    channelArn: Optional[ChimeArn] = Optional.Absent,
    createdTimestamp: Optional[Timestamp] = Optional.Absent,
    lastUpdatedTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMembership = {
    import ChannelMembership.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMembership
      .builder()
      .optionallyWith(invitedBy.map(value => value.buildAwsValue()))(
        _.invitedBy
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(member.map(value => value.buildAwsValue()))(_.member)
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        lastUpdatedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmessaging.model.ChannelMembership.ReadOnly =
    zio.aws.chimesdkmessaging.model.ChannelMembership.wrap(buildAwsValue())
}
object ChannelMembership {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMembership
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.ChannelMembership =
      zio.aws.chimesdkmessaging.model.ChannelMembership(
        invitedBy.map(value => value.asEditable),
        `type`.map(value => value),
        member.map(value => value.asEditable),
        channelArn.map(value => value),
        createdTimestamp.map(value => value),
        lastUpdatedTimestamp.map(value => value)
      )
    def invitedBy: Optional[zio.aws.chimesdkmessaging.model.Identity.ReadOnly]
    def `type`: Optional[zio.aws.chimesdkmessaging.model.ChannelMembershipType]
    def member: Optional[zio.aws.chimesdkmessaging.model.Identity.ReadOnly]
    def channelArn: Optional[ChimeArn]
    def createdTimestamp: Optional[Timestamp]
    def lastUpdatedTimestamp: Optional[Timestamp]
    def getInvitedBy: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.Identity.ReadOnly
    ] = AwsError.unwrapOptionField("invitedBy", invitedBy)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelMembershipType
    ] = AwsError.unwrapOptionField("type", `type`)
    def getMember: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.Identity.ReadOnly
    ] = AwsError.unwrapOptionField("member", member)
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getLastUpdatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMembership
  ) extends zio.aws.chimesdkmessaging.model.ChannelMembership.ReadOnly {
    override val invitedBy
        : Optional[zio.aws.chimesdkmessaging.model.Identity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invitedBy())
        .map(value => zio.aws.chimesdkmessaging.model.Identity.wrap(value))
    override val `type`
        : Optional[zio.aws.chimesdkmessaging.model.ChannelMembershipType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.chimesdkmessaging.model.ChannelMembershipType.wrap(value)
        )
    override val member
        : Optional[zio.aws.chimesdkmessaging.model.Identity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.member())
        .map(value => zio.aws.chimesdkmessaging.model.Identity.wrap(value))
    override val channelArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val createdTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTimestamp())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Timestamp(value))
    override val lastUpdatedTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTimestamp())
        .map(value =>
          zio.aws.chimesdkmessaging.model.primitives.Timestamp(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMembership
  ): zio.aws.chimesdkmessaging.model.ChannelMembership.ReadOnly = new Wrapper(
    impl
  )
}
