package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmessaging.model.primitives.ChimeArn
import scala.jdk.CollectionConverters._
final case class AssociateChannelFlowRequest(
    channelArn: ChimeArn,
    channelFlowArn: ChimeArn,
    chimeBearer: ChimeArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.AssociateChannelFlowRequest = {
    import AssociateChannelFlowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.AssociateChannelFlowRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .channelFlowArn(ChimeArn.unwrap(channelFlowArn): java.lang.String)
      .chimeBearer(ChimeArn.unwrap(chimeBearer): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.AssociateChannelFlowRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.AssociateChannelFlowRequest
      .wrap(buildAwsValue())
}
object AssociateChannelFlowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.AssociateChannelFlowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.AssociateChannelFlowRequest =
      zio.aws.chimesdkmessaging.model
        .AssociateChannelFlowRequest(channelArn, channelFlowArn, chimeBearer)
    def channelArn: ChimeArn
    def channelFlowArn: ChimeArn
    def chimeBearer: ChimeArn
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getChannelFlowArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(channelFlowArn)
    def getChimeBearer: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.AssociateChannelFlowRequest
  ) extends zio.aws.chimesdkmessaging.model.AssociateChannelFlowRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.channelArn())
    override val channelFlowArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.channelFlowArn())
    override val chimeBearer: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.chimeBearer())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.AssociateChannelFlowRequest
  ): zio.aws.chimesdkmessaging.model.AssociateChannelFlowRequest.ReadOnly =
    new Wrapper(impl)
}
