package zio.aws.chimesdkmessaging.model
import scala.jdk.CollectionConverters._
sealed trait FallbackAction {
  def unwrap
      : software.amazon.awssdk.services.chimesdkmessaging.model.FallbackAction
}
object FallbackAction {
  def wrap(
      value: software.amazon.awssdk.services.chimesdkmessaging.model.FallbackAction
  ): zio.aws.chimesdkmessaging.model.FallbackAction = value match {
    case software.amazon.awssdk.services.chimesdkmessaging.model.FallbackAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chimesdkmessaging.model.FallbackAction.CONTINUE =>
      val r = CONTINUE
      r
    case software.amazon.awssdk.services.chimesdkmessaging.model.FallbackAction.ABORT =>
      val r = ABORT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chimesdkmessaging.model.FallbackAction {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmessaging.model.FallbackAction =
      software.amazon.awssdk.services.chimesdkmessaging.model.FallbackAction.UNKNOWN_TO_SDK_VERSION
  }
  case object CONTINUE extends zio.aws.chimesdkmessaging.model.FallbackAction {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmessaging.model.FallbackAction =
      software.amazon.awssdk.services.chimesdkmessaging.model.FallbackAction.CONTINUE
  }
  case object ABORT extends zio.aws.chimesdkmessaging.model.FallbackAction {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmessaging.model.FallbackAction =
      software.amazon.awssdk.services.chimesdkmessaging.model.FallbackAction.ABORT
  }
}
