package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.ChimeArn
import scala.jdk.CollectionConverters._
final case class CreateChannelFlowResponse(
    channelFlowArn: Optional[ChimeArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelFlowResponse = {
    import CreateChannelFlowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelFlowResponse
      .builder()
      .optionallyWith(
        channelFlowArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelFlowArn)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.CreateChannelFlowResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.CreateChannelFlowResponse
      .wrap(buildAwsValue())
}
object CreateChannelFlowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelFlowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.CreateChannelFlowResponse =
      zio.aws.chimesdkmessaging.model
        .CreateChannelFlowResponse(channelFlowArn.map(value => value))
    def channelFlowArn: Optional[ChimeArn]
    def getChannelFlowArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelFlowArn", channelFlowArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelFlowResponse
  ) extends zio.aws.chimesdkmessaging.model.CreateChannelFlowResponse.ReadOnly {
    override val channelFlowArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelFlowArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelFlowResponse
  ): zio.aws.chimesdkmessaging.model.CreateChannelFlowResponse.ReadOnly =
    new Wrapper(impl)
}
