package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.chimesdkmessaging.model.primitives.{
  Timestamp,
  NonEmptyResourceName,
  ChimeArn
}
import scala.jdk.CollectionConverters._
final case class ChannelFlow(
    channelFlowArn: Option[ChimeArn] = None,
    processors: Option[Iterable[zio.aws.chimesdkmessaging.model.Processor]] =
      None,
    name: Option[NonEmptyResourceName] = None,
    createdTimestamp: Option[Timestamp] = None,
    lastUpdatedTimestamp: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlow = {
    import ChannelFlow.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlow
      .builder()
      .optionallyWith(
        channelFlowArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelFlowArn)
      .optionallyWith(
        processors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processors)
      .optionallyWith(
        name.map(value => NonEmptyResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        lastUpdatedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmessaging.model.ChannelFlow.ReadOnly =
    zio.aws.chimesdkmessaging.model.ChannelFlow.wrap(buildAwsValue())
}
object ChannelFlow {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlow
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.ChannelFlow =
      zio.aws.chimesdkmessaging.model.ChannelFlow(
        channelFlowArn.map(value => value),
        processors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name.map(value => value),
        createdTimestamp.map(value => value),
        lastUpdatedTimestamp.map(value => value)
      )
    def channelFlowArn: Option[ChimeArn]
    def processors
        : Option[List[zio.aws.chimesdkmessaging.model.Processor.ReadOnly]]
    def name: Option[NonEmptyResourceName]
    def createdTimestamp: Option[Timestamp]
    def lastUpdatedTimestamp: Option[Timestamp]
    def getChannelFlowArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelFlowArn", channelFlowArn)
    def getProcessors: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmessaging.model.Processor.ReadOnly
    ]] = AwsError.unwrapOptionField("processors", processors)
    def getName: ZIO[Any, AwsError, NonEmptyResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getLastUpdatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlow
  ) extends zio.aws.chimesdkmessaging.model.ChannelFlow.ReadOnly {
    override val channelFlowArn: Option[ChimeArn] = scala
      .Option(impl.channelFlowArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val processors
        : Option[List[zio.aws.chimesdkmessaging.model.Processor.ReadOnly]] =
      scala
        .Option(impl.processors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chimesdkmessaging.model.Processor.wrap(item)
          }.toList
        )
    override val name: Option[NonEmptyResourceName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.NonEmptyResourceName(value)
      )
    override val createdTimestamp: Option[Timestamp] = scala
      .Option(impl.createdTimestamp())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Timestamp(value))
    override val lastUpdatedTimestamp: Option[Timestamp] = scala
      .Option(impl.lastUpdatedTimestamp())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlow
  ): zio.aws.chimesdkmessaging.model.ChannelFlow.ReadOnly = new Wrapper(impl)
}
