package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmessaging.model.primitives.{
  Metadata,
  ChimeArn,
  NonEmptyResourceName
}
import scala.jdk.CollectionConverters._
final case class ChannelAssociatedWithFlowSummary(
    name: Option[NonEmptyResourceName] = None,
    channelArn: Option[ChimeArn] = None,
    mode: Option[zio.aws.chimesdkmessaging.model.ChannelMode] = None,
    privacy: Option[zio.aws.chimesdkmessaging.model.ChannelPrivacy] = None,
    metadata: Option[Metadata] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ChannelAssociatedWithFlowSummary = {
    import ChannelAssociatedWithFlowSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelAssociatedWithFlowSummary
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(privacy.map(value => value.unwrap))(_.privacy)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ChannelAssociatedWithFlowSummary.ReadOnly =
    zio.aws.chimesdkmessaging.model.ChannelAssociatedWithFlowSummary
      .wrap(buildAwsValue())
}
object ChannelAssociatedWithFlowSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelAssociatedWithFlowSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.ChannelAssociatedWithFlowSummary =
      zio.aws.chimesdkmessaging.model.ChannelAssociatedWithFlowSummary(
        name.map(value => value),
        channelArn.map(value => value),
        mode.map(value => value),
        privacy.map(value => value),
        metadata.map(value => value)
      )
    def name: Option[NonEmptyResourceName]
    def channelArn: Option[ChimeArn]
    def mode: Option[zio.aws.chimesdkmessaging.model.ChannelMode]
    def privacy: Option[zio.aws.chimesdkmessaging.model.ChannelPrivacy]
    def metadata: Option[Metadata]
    def getName: ZIO[Any, AwsError, NonEmptyResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getMode
        : ZIO[Any, AwsError, zio.aws.chimesdkmessaging.model.ChannelMode] =
      AwsError.unwrapOptionField("mode", mode)
    def getPrivacy
        : ZIO[Any, AwsError, zio.aws.chimesdkmessaging.model.ChannelPrivacy] =
      AwsError.unwrapOptionField("privacy", privacy)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelAssociatedWithFlowSummary
  ) extends zio.aws.chimesdkmessaging.model.ChannelAssociatedWithFlowSummary.ReadOnly {
    override val name: Option[NonEmptyResourceName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.NonEmptyResourceName(value)
      )
    override val channelArn: Option[ChimeArn] = scala
      .Option(impl.channelArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val mode: Option[zio.aws.chimesdkmessaging.model.ChannelMode] =
      scala
        .Option(impl.mode())
        .map(value => zio.aws.chimesdkmessaging.model.ChannelMode.wrap(value))
    override val privacy
        : Option[zio.aws.chimesdkmessaging.model.ChannelPrivacy] = scala
      .Option(impl.privacy())
      .map(value => zio.aws.chimesdkmessaging.model.ChannelPrivacy.wrap(value))
    override val metadata: Option[Metadata] = scala
      .Option(impl.metadata())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Metadata(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelAssociatedWithFlowSummary
  ): zio.aws.chimesdkmessaging.model.ChannelAssociatedWithFlowSummary.ReadOnly =
    new Wrapper(impl)
}
