package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmessaging.model.primitives.{ResourceName, ChimeArn}
import scala.jdk.CollectionConverters._
final case class Identity(
    arn: Option[ChimeArn] = None,
    name: Option[ResourceName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.Identity = {
    import Identity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.Identity
      .builder()
      .optionallyWith(
        arn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmessaging.model.Identity.ReadOnly =
    zio.aws.chimesdkmessaging.model.Identity.wrap(buildAwsValue())
}
object Identity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.Identity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.Identity =
      zio.aws.chimesdkmessaging.model
        .Identity(arn.map(value => value), name.map(value => value))
    def arn: Option[ChimeArn]
    def name: Option[ResourceName]
    def getArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.Identity
  ) extends zio.aws.chimesdkmessaging.model.Identity.ReadOnly {
    override val arn: Option[ChimeArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.ResourceName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.Identity
  ): zio.aws.chimesdkmessaging.model.Identity.ReadOnly = new Wrapper(impl)
}
