package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmessaging.model.primitives.{
  Metadata,
  Content,
  MessageId,
  ChimeArn
}
import scala.jdk.CollectionConverters._
final case class UpdateChannelMessageRequest(
    channelArn: ChimeArn,
    messageId: MessageId,
    content: Option[Content] = None,
    metadata: Option[Metadata] = None,
    chimeBearer: ChimeArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelMessageRequest = {
    import UpdateChannelMessageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelMessageRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .messageId(MessageId.unwrap(messageId): java.lang.String)
      .optionallyWith(
        content.map(value => Content.unwrap(value): java.lang.String)
      )(_.content)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .chimeBearer(ChimeArn.unwrap(chimeBearer): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.UpdateChannelMessageRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.UpdateChannelMessageRequest
      .wrap(buildAwsValue())
}
object UpdateChannelMessageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelMessageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.UpdateChannelMessageRequest =
      zio.aws.chimesdkmessaging.model.UpdateChannelMessageRequest(
        channelArn,
        messageId,
        content.map(value => value),
        metadata.map(value => value),
        chimeBearer
      )
    def channelArn: ChimeArn
    def messageId: MessageId
    def content: Option[Content]
    def metadata: Option[Metadata]
    def chimeBearer: ChimeArn
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getMessageId: ZIO[Any, Nothing, MessageId] = ZIO.succeed(messageId)
    def getContent: ZIO[Any, AwsError, Content] =
      AwsError.unwrapOptionField("content", content)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getChimeBearer: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelMessageRequest
  ) extends zio.aws.chimesdkmessaging.model.UpdateChannelMessageRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.channelArn())
    override val messageId: MessageId =
      zio.aws.chimesdkmessaging.model.primitives.MessageId(impl.messageId())
    override val content: Option[Content] = scala
      .Option(impl.content())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Content(value))
    override val metadata: Option[Metadata] = scala
      .Option(impl.metadata())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Metadata(value))
    override val chimeBearer: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.chimeBearer())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelMessageRequest
  ): zio.aws.chimesdkmessaging.model.UpdateChannelMessageRequest.ReadOnly =
    new Wrapper(impl)
}
