package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmessaging.model.primitives.{
  ClientRequestToken,
  NonEmptyResourceName,
  ChimeArn
}
import scala.jdk.CollectionConverters._
final case class CreateChannelFlowRequest(
    appInstanceArn: ChimeArn,
    processors: Iterable[zio.aws.chimesdkmessaging.model.Processor],
    name: NonEmptyResourceName,
    tags: Option[Iterable[zio.aws.chimesdkmessaging.model.Tag]] = None,
    clientRequestToken: ClientRequestToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelFlowRequest = {
    import CreateChannelFlowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelFlowRequest
      .builder()
      .appInstanceArn(ChimeArn.unwrap(appInstanceArn): java.lang.String)
      .processors(processors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .name(NonEmptyResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .clientRequestToken(
        ClientRequestToken.unwrap(clientRequestToken): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.CreateChannelFlowRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.CreateChannelFlowRequest
      .wrap(buildAwsValue())
}
object CreateChannelFlowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelFlowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.CreateChannelFlowRequest =
      zio.aws.chimesdkmessaging.model.CreateChannelFlowRequest(
        appInstanceArn,
        processors.map { item =>
          item.asEditable
        },
        name,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientRequestToken
      )
    def appInstanceArn: ChimeArn
    def processors: List[zio.aws.chimesdkmessaging.model.Processor.ReadOnly]
    def name: NonEmptyResourceName
    def tags: Option[List[zio.aws.chimesdkmessaging.model.Tag.ReadOnly]]
    def clientRequestToken: ClientRequestToken
    def getAppInstanceArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(appInstanceArn)
    def getProcessors: ZIO[Any, Nothing, List[
      zio.aws.chimesdkmessaging.model.Processor.ReadOnly
    ]] = ZIO.succeed(processors)
    def getName: ZIO[Any, Nothing, NonEmptyResourceName] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmessaging.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getClientRequestToken: ZIO[Any, Nothing, ClientRequestToken] =
      ZIO.succeed(clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelFlowRequest
  ) extends zio.aws.chimesdkmessaging.model.CreateChannelFlowRequest.ReadOnly {
    override val appInstanceArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.appInstanceArn())
    override val processors
        : List[zio.aws.chimesdkmessaging.model.Processor.ReadOnly] = impl
      .processors()
      .asScala
      .map { item =>
        zio.aws.chimesdkmessaging.model.Processor.wrap(item)
      }
      .toList
    override val name: NonEmptyResourceName =
      zio.aws.chimesdkmessaging.model.primitives
        .NonEmptyResourceName(impl.name())
    override val tags
        : Option[List[zio.aws.chimesdkmessaging.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkmessaging.model.Tag.wrap(item)
        }.toList
      )
    override val clientRequestToken: ClientRequestToken =
      zio.aws.chimesdkmessaging.model.primitives
        .ClientRequestToken(impl.clientRequestToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelFlowRequest
  ): zio.aws.chimesdkmessaging.model.CreateChannelFlowRequest.ReadOnly =
    new Wrapper(impl)
}
