package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmessaging.model.primitives.{MessageId, ChimeArn}
import scala.jdk.CollectionConverters._
final case class DeleteChannelMessageRequest(
    channelArn: ChimeArn,
    messageId: MessageId,
    chimeBearer: ChimeArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.DeleteChannelMessageRequest = {
    import DeleteChannelMessageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.DeleteChannelMessageRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .messageId(MessageId.unwrap(messageId): java.lang.String)
      .chimeBearer(ChimeArn.unwrap(chimeBearer): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.DeleteChannelMessageRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.DeleteChannelMessageRequest
      .wrap(buildAwsValue())
}
object DeleteChannelMessageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.DeleteChannelMessageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.DeleteChannelMessageRequest =
      zio.aws.chimesdkmessaging.model
        .DeleteChannelMessageRequest(channelArn, messageId, chimeBearer)
    def channelArn: ChimeArn
    def messageId: MessageId
    def chimeBearer: ChimeArn
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getMessageId: ZIO[Any, Nothing, MessageId] = ZIO.succeed(messageId)
    def getChimeBearer: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.DeleteChannelMessageRequest
  ) extends zio.aws.chimesdkmessaging.model.DeleteChannelMessageRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.channelArn())
    override val messageId: MessageId =
      zio.aws.chimesdkmessaging.model.primitives.MessageId(impl.messageId())
    override val chimeBearer: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.chimeBearer())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.DeleteChannelMessageRequest
  ): zio.aws.chimesdkmessaging.model.DeleteChannelMessageRequest.ReadOnly =
    new Wrapper(impl)
}
