package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmessaging.model.primitives.{
  MessageAttributeName,
  Metadata,
  NonEmptyContent,
  MessageId
}
import scala.jdk.CollectionConverters._
final case class ChannelMessageCallback(
    messageId: MessageId,
    content: Option[NonEmptyContent] = None,
    metadata: Option[Metadata] = None,
    pushNotification: Option[
      zio.aws.chimesdkmessaging.model.PushNotificationConfiguration
    ] = None,
    messageAttributes: Option[Map[
      MessageAttributeName,
      zio.aws.chimesdkmessaging.model.MessageAttributeValue
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageCallback = {
    import ChannelMessageCallback.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageCallback
      .builder()
      .messageId(MessageId.unwrap(messageId): java.lang.String)
      .optionallyWith(
        content.map(value => NonEmptyContent.unwrap(value): java.lang.String)
      )(_.content)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .optionallyWith(pushNotification.map(value => value.buildAwsValue()))(
        _.pushNotification
      )
      .optionallyWith(
        messageAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (MessageAttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.messageAttributes)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ChannelMessageCallback.ReadOnly =
    zio.aws.chimesdkmessaging.model.ChannelMessageCallback.wrap(buildAwsValue())
}
object ChannelMessageCallback {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageCallback
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.ChannelMessageCallback =
      zio.aws.chimesdkmessaging.model.ChannelMessageCallback(
        messageId,
        content.map(value => value),
        metadata.map(value => value),
        pushNotification.map(value => value.asEditable),
        messageAttributes.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def messageId: MessageId
    def content: Option[NonEmptyContent]
    def metadata: Option[Metadata]
    def pushNotification: Option[
      zio.aws.chimesdkmessaging.model.PushNotificationConfiguration.ReadOnly
    ]
    def messageAttributes: Option[Map[
      MessageAttributeName,
      zio.aws.chimesdkmessaging.model.MessageAttributeValue.ReadOnly
    ]]
    def getMessageId: ZIO[Any, Nothing, MessageId] = ZIO.succeed(messageId)
    def getContent: ZIO[Any, AwsError, NonEmptyContent] =
      AwsError.unwrapOptionField("content", content)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getPushNotification: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.PushNotificationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("pushNotification", pushNotification)
    def getMessageAttributes: ZIO[Any, AwsError, Map[
      MessageAttributeName,
      zio.aws.chimesdkmessaging.model.MessageAttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("messageAttributes", messageAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageCallback
  ) extends zio.aws.chimesdkmessaging.model.ChannelMessageCallback.ReadOnly {
    override val messageId: MessageId =
      zio.aws.chimesdkmessaging.model.primitives.MessageId(impl.messageId())
    override val content: Option[NonEmptyContent] = scala
      .Option(impl.content())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.NonEmptyContent(value)
      )
    override val metadata: Option[Metadata] = scala
      .Option(impl.metadata())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Metadata(value))
    override val pushNotification: Option[
      zio.aws.chimesdkmessaging.model.PushNotificationConfiguration.ReadOnly
    ] = scala
      .Option(impl.pushNotification())
      .map(value =>
        zio.aws.chimesdkmessaging.model.PushNotificationConfiguration
          .wrap(value)
      )
    override val messageAttributes: Option[Map[
      MessageAttributeName,
      zio.aws.chimesdkmessaging.model.MessageAttributeValue.ReadOnly
    ]] = scala
      .Option(impl.messageAttributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.chimesdkmessaging.model.primitives.MessageAttributeName(
              key
            ) -> zio.aws.chimesdkmessaging.model.MessageAttributeValue
              .wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageCallback
  ): zio.aws.chimesdkmessaging.model.ChannelMessageCallback.ReadOnly =
    new Wrapper(impl)
}
