package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ChannelMembershipPreferences(
    pushNotifications: Option[
      zio.aws.chimesdkmessaging.model.PushNotificationPreferences
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMembershipPreferences = {
    import ChannelMembershipPreferences.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMembershipPreferences
      .builder()
      .optionallyWith(pushNotifications.map(value => value.buildAwsValue()))(
        _.pushNotifications
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ChannelMembershipPreferences.ReadOnly =
    zio.aws.chimesdkmessaging.model.ChannelMembershipPreferences
      .wrap(buildAwsValue())
}
object ChannelMembershipPreferences {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMembershipPreferences
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.ChannelMembershipPreferences =
      zio.aws.chimesdkmessaging.model.ChannelMembershipPreferences(
        pushNotifications.map(value => value.asEditable)
      )
    def pushNotifications: Option[
      zio.aws.chimesdkmessaging.model.PushNotificationPreferences.ReadOnly
    ]
    def getPushNotifications: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.PushNotificationPreferences.ReadOnly
    ] = AwsError.unwrapOptionField("pushNotifications", pushNotifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMembershipPreferences
  ) extends zio.aws.chimesdkmessaging.model.ChannelMembershipPreferences.ReadOnly {
    override val pushNotifications: Option[
      zio.aws.chimesdkmessaging.model.PushNotificationPreferences.ReadOnly
    ] = scala
      .Option(impl.pushNotifications())
      .map(value =>
        zio.aws.chimesdkmessaging.model.PushNotificationPreferences.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMembershipPreferences
  ): zio.aws.chimesdkmessaging.model.ChannelMembershipPreferences.ReadOnly =
    new Wrapper(impl)
}
