package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmessaging.model.primitives.MessageAttributeStringValue
import scala.jdk.CollectionConverters._
final case class MessageAttributeValue(
    stringValues: Option[Iterable[MessageAttributeStringValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.MessageAttributeValue = {
    import MessageAttributeValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.MessageAttributeValue
      .builder()
      .optionallyWith(
        stringValues.map(value =>
          value.map { item =>
            MessageAttributeStringValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.stringValues)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.MessageAttributeValue.ReadOnly =
    zio.aws.chimesdkmessaging.model.MessageAttributeValue.wrap(buildAwsValue())
}
object MessageAttributeValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.MessageAttributeValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.MessageAttributeValue =
      zio.aws.chimesdkmessaging.model
        .MessageAttributeValue(stringValues.map(value => value))
    def stringValues: Option[List[MessageAttributeStringValue]]
    def getStringValues: ZIO[Any, AwsError, List[MessageAttributeStringValue]] =
      AwsError.unwrapOptionField("stringValues", stringValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.MessageAttributeValue
  ) extends zio.aws.chimesdkmessaging.model.MessageAttributeValue.ReadOnly {
    override val stringValues: Option[List[MessageAttributeStringValue]] = scala
      .Option(impl.stringValues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkmessaging.model.primitives
            .MessageAttributeStringValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.MessageAttributeValue
  ): zio.aws.chimesdkmessaging.model.MessageAttributeValue.ReadOnly =
    new Wrapper(impl)
}
