package zio.aws.chimesdkmessaging.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmessaging.model.primitives.{
  NextToken,
  MaxResults,
  ChimeArn
}
import scala.jdk.CollectionConverters._
final case class ListChannelsRequest(
    appInstanceArn: ChimeArn,
    privacy: Option[zio.aws.chimesdkmessaging.model.ChannelPrivacy] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None,
    chimeBearer: ChimeArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelsRequest = {
    import ListChannelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelsRequest
      .builder()
      .appInstanceArn(ChimeArn.unwrap(appInstanceArn): java.lang.String)
      .optionallyWith(privacy.map(value => value.unwrap))(_.privacy)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .chimeBearer(ChimeArn.unwrap(chimeBearer): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmessaging.model.ListChannelsRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.ListChannelsRequest.wrap(buildAwsValue())
}
object ListChannelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.ListChannelsRequest =
      zio.aws.chimesdkmessaging.model.ListChannelsRequest(
        appInstanceArn,
        privacy.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        chimeBearer
      )
    def appInstanceArn: ChimeArn
    def privacy: Option[zio.aws.chimesdkmessaging.model.ChannelPrivacy]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def chimeBearer: ChimeArn
    def getAppInstanceArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(appInstanceArn)
    def getPrivacy
        : ZIO[Any, AwsError, zio.aws.chimesdkmessaging.model.ChannelPrivacy] =
      AwsError.unwrapOptionField("privacy", privacy)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getChimeBearer: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelsRequest
  ) extends zio.aws.chimesdkmessaging.model.ListChannelsRequest.ReadOnly {
    override val appInstanceArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.appInstanceArn())
    override val privacy
        : Option[zio.aws.chimesdkmessaging.model.ChannelPrivacy] = scala
      .Option(impl.privacy())
      .map(value => zio.aws.chimesdkmessaging.model.ChannelPrivacy.wrap(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.MaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.NextToken(value))
    override val chimeBearer: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.chimeBearer())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelsRequest
  ): zio.aws.chimesdkmessaging.model.ListChannelsRequest.ReadOnly = new Wrapper(
    impl
  )
}
